% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-function.R, R/is-function.R
\name{assert_is_internal_function}
\alias{assert_is_internal_function}
\alias{is_internal_function}
\title{Is the input an internal function?}
\usage{
assert_is_internal_function(x, severity = getOption("assertive.severity",
  "stop"))

is_internal_function(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_internal_function} returns \code{TRUE} when the input is a 
closure function that calls \code{\link[base]{.Internal}}.  The 
\code{assert_*} function returns nothing but throw an error if the 
corresponding \code{is_*} function returns \code{FALSE}.
}
\description{
Checks to see if the input is an internal function. That is, it is a 
non-primitive function that calls C-code via \code{\link[base]{.Internal}}.
}
\examples{
# Some common fns calling .Internal
is_internal_function(unlist)
is_internal_function(cbind)

# Some failures
assertive.base::dont_stop({
assert_is_internal_function("unlist")
assert_is_internal_function(sqrt)
assert_is_internal_function(function(){})
})
}
\references{
This function is modeled upon \code{is_internal}, internal to the
\code{pryr} package.
The differences between the \code{.Internal} and \code{.Primitive} interfaces
to C code are discussed in R-Internals, in the chapter Internal vs. Primitive.
\url{https://cran.r-project.org/doc/manuals/r-devel/R-ints.html#g_t_002eInternal-vs-_002ePrimitive}
}
\seealso{
\code{\link[base]{is.function}} and its assertive wrapper
\code{\link{is_function}}.
}

