% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-r-has-capability.R, R/r-has-capability.R
\name{assert_r_can_find_tools}
\alias{assert_r_can_build_translations}
\alias{assert_r_can_compile_code}
\alias{assert_r_can_find_java}
\alias{assert_r_can_find_tools}
\alias{r_can_build_translations}
\alias{r_can_compile_code}
\alias{r_can_find_java}
\alias{r_can_find_tools}
\title{Can R find tools?}
\usage{
assert_r_can_find_tools(tools, severity = getOption("assertive.severity",
  "stop"))

assert_r_can_compile_code(severity = getOption("assertive.severity", "stop"))

assert_r_can_build_translations(severity = getOption("assertive.severity",
  "stop"))

assert_r_can_find_java(java_type = c("same_as_r", "any", "64bit", "32bit"),
  severity = getOption("assertive.severity", "stop"))

r_can_find_tools(tools)

r_can_compile_code()

r_can_build_translations()

r_can_find_java(java_type = c("same_as_r", "any", "64bit", "32bit"))
}
\arguments{
\item{tools}{A character vector of tools to look for.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{java_type}{A string denoting the type of Java to look for (either 
32 or 64 bit).}
}
\value{
The \code{is_*} functions return \code{TRUE} if the input is 
within an interval.  The \code{assert_*} functions return nothing but
throw an error if the corresponding \code{is_*} function returns 
\code{FALSE}.
}
\description{
Checks to see if R can see command line tools.
}
\note{
\code{r_can_compile_code} is a convenience function looking for
\code{gcc} and \code{make}.

\code{r_can_build_translations} is a convenience function looking for
\code{gettext} and \code{msgfmt}.
}
\examples{
r_can_find_tools(c("latex", "pdflatex"))
r_can_compile_code()
r_can_build_translations()
r_can_find_java()
assertive.base::dont_stop({
  assert_r_can_find_tools(c("latex", "pdflatex"))
  assert_r_can_compile_code()
  assert_r_can_build_translations()
  assert_r_can_find_java("64bit")
})
}
\seealso{
\code{\link[base]{Sys.which}}
}

