% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_colnames.R
\name{assert_colnames}
\alias{assert_colnames}
\title{Assert that a data.frame contains specified column names}
\usage{
assert_colnames(data, colnames, only_colnames = TRUE)
}
\arguments{
\item{data}{A data.frame or data.table}

\item{colnames}{Character vector with column names corresponding to columns in \emph{data}}

\item{only_colnames}{Assert that the only columns in the data object should be those in \emph{colnames}. Default = T.}
}
\value{
Throws error if test is violated.
}
\description{
Given a data.frame or data.table object, assert that all columns in the colnames argument exist as columns.
}
\examples{
assert_colnames(CO2, c("Plant","Type","Treatment","conc","uptake"))
assert_colnames(CO2, c("Plant","Type"), only_colnames=FALSE)
}
