\name{setvarianceterms.call}
\alias{setvarianceterms.call}
\alias{setvarianceterms}
\title{allows the setting of bounds and initial values for terms in the 
       \code{random} and \code{residual} arguments of an \code{asreml} call, with 
       the resulting call being evaluated. }
\description{Takes an unevaluated \code{call} and evaluates the \code{call} 
             after setting the bounds and initial values for the terms 
             specified in \code{terms}. The elements of \code{terms} are matched 
             with those generated by asreml and used, for example, in the 
             \code{varcomp} component of a \code{summary.asreml} object. 
             These names generally include descriptive suffices. To match an 
             element of \code{terms} that includes such a suffix, set 
             \code{ignore.suffices} to \code{FALSE} so that a literal match 
             between the element and the assigned names is sought.}
\usage{
\method{setvarianceterms}{call}(call, terms, ignore.suffices = TRUE, 
                 bounds = "P", initial.values = NA, ...)}
\arguments{
 \item{call}{an unevaluated \code{call} to \code{asreml}. One way to create 
             such a \code{call} is to use the \code{call} function with 
             its \code{name} argument set to \code{"asreml"}. Another is to 
             obtain it from the \code{call} component of an \code{asreml} 
             object  (e.g. \code{call <- asreml.obj$call}).}
 \item{terms}{A character vector specifying the terms 
              that are to have bounds and/or initial values specified.
               The names must match those in the \code{vparameters} component of the 
               \code{asreml.obj} component in the \code{\link{asrtests.object}}.}
 \item{ignore.suffices}{A logical vector specifying whether the suffices of the 
                    \code{asreml}-assigned names of the variance terms (i.e. the 
                    information to the right of an "!", other than "R!") is to be ignored in 
                    matching elements of \code{terms}. If \code{TRUE} for 
                    an element of \code{terms}, the suffices are stripped 
                    from the \code{asreml}-assigned names. If \code{FALSE} for 
                    an element of \code{terms}, the element must exactly match 
                    an \code{asreml}-assigned name for a variance term. This vector 
                    must be of length one or the same length as \code{terms}. 
                    If it is of length one then the same action is 
                    applied to the \code{asreml}-assigned suffices for all the terms 
                    in \code{terms}.}
 \item{bounds}{A \code{\link{character}} vector specifying the bounds to be applied 
                    to the terms specified in \code{set.terms}. This vector 
                    must be of length one or the same length as \code{set.terms}. 
                    If it is of length one then the same constraint is 
                    applied to all the terms in \code{set.terms}. 
                    If any of the bounds are equal to NA then they are 
                    left unchanged for those terms.

                    The codes used by ASReml are: 
                   \itemize{
                     \item B - fixed at a boundary;
                     \item F - fixed by the user;
                     \item P - positive definite;
                     \item C - Constrained by user; 
                     \item U - unbounded.
                   }}
 \item{initial.values}{A character vector specifying the initial values for  
                    the terms specified in \code{terms}. This vector 
                    must be of length one or the same length as \code{terms}. 
                    If it is of length one then the same initial value is 
                    applied to all the terms in \code{terms}. 
                    If any of the initial.values are equal to NA then they are 
                    left unchanged for those terms.}
 \item{\dots}{additional arguments to be added to the call, or arguments in 
            the call with changed values.}
}
\value{An \code{asreml} object.}


\references{Butler, D. G., Cullis, B. R., Gilmour, A. R., Gogel, B. J. and 
            Thompson, R. (2018). \emph{{ASReml-R} Reference Manual Version 4.}  
            VSN International Ltd, \url{https://asreml.kb.vsni.co.uk/}.}

\author{Chris Brien}
\seealso{\code{update.asreml}}
\examples{\dontrun{
   m1.call <- call("asreml", 
                   fixed = Height ~ (Block + Irrig)*csDay.num,
                   random= ~ spl(csDay.num)/(Irrig+Block)
                             + dev(csDay.num)
                             + str(~Block:Plot/csDay.num, ~us(2):id(20)) 
                             + Block:Plot:spl(csDay.num),
                   data=quote(dat)) ##use quote to stop evaluation of dat here 
   terms <- c("Block:Plot+Block:Plot:csDay.num!us(2).2:1", "R!variance")
   m1.asreml <- setvarianceterms(m1.call, terms, bounds=c("U","P"), 
                                 initial=c(NA,3), ignore.suffices=c(FALSE,TRUE))
   summary(m1.asreml)
}}
\keyword{asreml}