*-------------------------------------------------------------------------*
 |                                                                        |
 |             SPSS DATA DEFINITION STATEMENTS FOR ICPSR 2939             |
 |             MONITORING THE FUTURE, 1999 (12th GRADE SURVEY)            |
 |                         (PART 1: CORE DATA)                            |
 |                           2nd ICPSR EDITION                            |
 |                             January, 2003                              |
 |                                                                        |
 |                                                                        |
 | SPSS setup sections are provided for the LRECL version of this data    |
 | collection.  These sections are listed below:                          |
 |                                                                        |
 | DATA LIST:  assigns the name, type, decimal specification (if any),    |
 | and specifies the beginning and ending column locations for each       |
 | variable in the data file.  Users must replace the "data-filename"     |
 | in the DATA LIST statement with a filename specifying the directory    |
 | on the user's computer system in which the downloaded and unzipped     |
 | data file is physically located (e.g., "c:\temp\da6949.p1").           |
 |                                                                        |
 | VARIABLE LABELS:  assigns descriptive labels to all variables.         |
 | Labels and variable names may be identical for some data files.        |
 |                                                                        |
 | MISSING VALUES:  declares user-defined missing values.  Not all        |
 | variables in this data set necessarily have user-defined missing       |
 | values.  These values can be treated specially in data transformations,|
 | statistical calculations, and case selection.                          |
 |                                                                        |
 | VALUE LABELS:  assigns descriptive labels to codes found in the data   |
 | file.  Not all codes necessarily have assigned value labels.           |
 |                                                                        |
 | NOTE:  Users should modify these data definition statements to suit    |
 | their specific needs.  The MISSING VALUES section has been commented   |
 | out (i.e., '*').  To include the MISSING VALUES section in the final   |
 | SPSS setup, remove the comment indicators from the desired section.    |
 |                                                                        |
 | These data definition statements have been tested for compatibility    |
 | with SPSS Release 6.13 for UNIX and/or SPSS Release 10.0 for Windows.  |
 |                                                                        |
 | CREATING A PERMANENT SPSS DATA FILE:  If users wish to create and save |
 | an SPSS data file for further analysis using SPSS for Windows, the     |
 | necessary "SAVE OUTFILE" command is provided in the last line of       |
 | this file.  To activate the command, users must delete the leading     |
 | asterisk (*) and replace "spss-filename" with a filename specifying    |
 | the location on the user's computer system to which the new data file  |
 | will be saved (e.g., SAVE OUTFILE="c:\spsswin\data\nhsda82.sav").      |
*-------------------------------------------------------------------------.
                                                                           
                                                                           
* SPSS DATA LIST COMMAND.                                                  
                                                                           
DATA LIST FILE="data-filename" /                                           
   V13 1-1                  V16 2-2                  V17 3-3               
   V5 4-9 (4)               V1 10-13                 V3 14-14              
   V4 15-19                 V130 20-21               V131 22-23            
   V132 24-25               V49 26-27                V101 28-29            
   V102 30-31               V103 32-33               V104 34-35            
   V105 36-37               V106 38-39               V107 40-41            
   V108 42-43               V115 44-45               V116 46-47            
   V117 48-49               V118 50-51               V119 52-53            
   V120 54-55               V121 56-57               V122 58-59            
   V123 60-61               V124 62-63               V125 64-65            
   V126 66-67               V127 68-69               V128 70-71            
   V129 72-73               V133 74-75               V134 76-77            
   V135 78-79               V136 80-81               V137 82-83            
   V138 84-85               V139 86-87               V140 88-89            
   V141 90-91               V142 92-93               V143 94-95            
   V144 96-97               V145 98-99               V146 100-101          
   V147 102-103             V148 104-105             V150 106-107          
   V151 108-109             V152 110-111             V153 112-113          
   V155 114-115             V156 116-117             V157 118-119          
   V163 120-121             V164 122-123             V165 124-125          
   V166 126-127             V167 128-129             V169 130-131          
   V170 132-133             V171 134-135             V172 136-137          
   V173 138-139             V174 140-141             V175 142-143          
   V176 144-145             V177 146-147             V178 148-149          
   V179 150-151             V180 152-153             V181 154-155          
   V182 156-157             V183 158-159             V184 160-161          
   V185 162-163             V186 164-165             V187 166-167          
   V188 168-169             V189 170-171             V190 172-173          
   V191 174-175             V192 176-177             V193 178-179          
   V194 180-181             V195 182-183             V196 184-185          
   V197 186-187             V198 188-189             V199 190-191          
   V200 192-193             V201 194-195             V202 196-197          
   V203 198-199             V204 200-201             V109 202-203          
   V110 204-205             V111 206-207             V112 208-209          
   V113 210-211             V114 212-213             V205 214-215          
   V206 216-217             V207 218-219             CASEID 220-224.       
                                                                           
* SPSS VARIABLE LABELS COMMAND.                                            
                                                                           
VARIABLE LABELS                                                            
   V13 "992     :SCHL RGN-4 CAT"                                           
   V16 "992     :SELF-REP/NOT=0"                                           
   V17 "992     :SMSA/NON-SMSA=0"                                          
   V5 "SAMPLING WEIGHT"                                                    
   V1 "YEAR OF ADMIN (4-DIGITS)"                                           
   V3 "992    :FORM ID"                                                    
   V4 "992    :R'S ID-SERIAL #"                                            
   V130 "9925B12A:#X ICE/LIFETIME"                                         
   V131 "9925B12B:#X ICE/LAST12MO"                                         
   V132 "9925B12C:#X ICE/LAST30DA"                                         
   V49 "992C07AB:# SIBLINGS"                                               
   V101 "992B01 :EVR SMK CIG,REGL"                                         
   V102 "992B02 :#CIGS SMKD/30DAY"                                         
   V103 "99*B03 :EVER DRINK"                                               
   V104 "992B04A:#X ALC/LIF SIPS"                                          
   V105 "992B04B:#X ALC/ANN SIPS"                                          
   V106 "992B04C:#X ALC/30D SIPS"                                          
   V107 "992B05 :#X DRK ENF FL HI"                                         
   V108 "992B06 :5+DRK ROW/LST 2W"                                         
   V115 "99*B07A:#XMJ+HS/LIFETIME"                                         
   V116 "99*B07B:#XMJ+HS/LAST12MO"                                         
   V117 "99*B07C:#XMJ+HS/LAST30DA"                                         
   V118 "992B08A:#X LSD/LIFETIME"                                          
   V119 "992B08B:#X LSD/LAST 12MO"                                         
   V120 "992B08C:#X LSD/LAST 30DA"                                         
   V121 "992B09A:#X PSYD/LIFETIME"                                         
   V122 "992B09B:#X PSYD/LAST12MO"                                         
   V123 "992B09C:#X PSYD/LAST30DA"                                         
   V124 "99*B10A:#X COKE/LIFETIME"                                         
   V125 "99*B10B:#X COKE/LAST12MO"                                         
   V126 "99*B10C:#X COKE/LAST30DA"                                         
   V127 "992B11A:#X AMPH/LIFETIME"                                         
   V128 "992B11B:#X AMPH/LAST12MO"                                         
   V129 "992B11C:#X AMPH/LAST30DA"                                         
   V133 "992B13A:#X BRBT/LIFETIME"                                         
   V134 "992B13B:#X BRBT/LAST12MO"                                         
   V135 "992B13C:#X BRBT/LAST30DA"                                         
   V136 "992B14A:#X TRQL/LIFETIME"                                         
   V137 "992B14B:#X TRQL/LAST12MO"                                         
   V138 "992B14C:#X TRQL/LAST30DA"                                         
   V139 "99*B15A:#X 'H'/LIFETIME"                                          
   V140 "99*B15B:#X 'H'/LAST12MO"                                          
   V141 "99*B15C:#X 'H'/LAST30DA"                                          
   V142 "992B17A:#X NARC/LIFETIME"                                         
   V143 "992B17B:#X NARC/LAST12MO"                                         
   V144 "992B17C:#X NARC/LAST30DA"                                         
   V145 "99*B18A:#X INHL/LIFETIME"                                         
   V146 "99*B18B:#X INHL/LAST12MO"                                         
   V147 "99*B18C:#X INHL/LAST30DA"                                         
   V148 "992(R)  :AGE <>18 DICHOTOMY"                                      
   V150 "992C03 :R'S SEX"                                                  
   V151 "992C04(R)R'S RACE"                                                
   V152 "992C05 :R SPD >TIM R-URB"                                         
   V153 "992C06 :R NOT MARRIED"                                            
   V155 "992C07Cb(R):R'S HSHLD FATHER"                                     
   V156 "992C07Cc(R):R'S HSHLD MOTHER"                                     
   V157 "992C07Cd(R):R'S HSHLD BR/SR"                                      
   V163 "992C08 :FATHR EDUC LEVEL"                                         
   V164 "992C09 :MOTHR EDUC LEVEL"                                         
   V165 "992C10 :MOTH PD JB R YNG"                                         
   V166 "992C11 :R'S POLTL PRFNC"                                          
   V167 "992C12 :R'POL BLF RADCL"                                          
   V169 "992C13B:R'ATTND REL SVC"                                          
   V170 "992C13C:RLGN IMP R'S LF"                                          
   V171 "992C14 :WHEN R XPCT GRAD"                                         
   V172 "992C15 :R'S HS PROGRAM"                                           
   V173 "992C16 :RT SF SCH AB>AVG"                                         
   V174 "992C17 :RT SF INTELL>AVG"                                         
   V175 "992C18A:#DA/4W SC MS ILL"                                         
   V176 "992C18B:#DA/4W SC MS CUT"                                         
   V177 "992C18C:#DA/4W SC MS OTH"                                         
   V178 "992C19 :#DA/4W SKP CLASS"                                         
   V179 "992C20 :R HS GRADE/D=1"                                           
   V180 "992C21A:R WL DO VOC/TEC"                                          
   V181 "992C21B:R WL DO ARMD FC"                                          
   V182 "992C21C:R WL DO 2YR CLG"                                          
   V183 "992C21D:R WL DO 4YR CLG"                                          
   V184 "992C21E:R WL DO GRD/PRF"                                          
   V185 "992C22A:R WNTDO VOC/TEC"                                          
   V186 "992C22B:R WNTDO ARMD FC"                                          
   V187 "992C22C:R WNTDO 2YR CLG"                                          
   V188 "992C22D:R WNTDO 4YR CLG"                                          
   V189 "992C22E:R WNTDO GRD/PRF"                                          
   V190 "992C22F:R WNTDO NONE"                                             
   V191 "992C23 :HRS/W WRK SCHYR"                                          
   V192 "992C24A:R$/AVG WEEK JOB"                                          
   V193 "992C24B:R$/AVG WEEK OTH"                                          
   V194 "992C25 :#X/AV WK GO OUT"                                          
   V195 "992C26 :#X DATE 3+/WK"                                            
   V196 "992C27 :DRIVE>200 MI/WK"                                          
   V197 "992C28 :#X/12MO R TCKTD"                                          
   V198 "992C29AR#TCKTS AFT DRNK"                                          
   V199 "992C29BR#TCKTS AFT MARJ"                                          
   V200 "992C29CR#TCKTS AFT OTDG"                                          
   V201 "992C30 :#ACCIDNTS/12 MO"                                          
   V202 "992C31AR#ACDTS AFT DRNK"                                          
   V203 "992C31BR#ACDTS AFT MARJ"                                          
   V204 "992C31CR#ACDTS AFT OTDG"                                          
   V109 "991B18A:#X HASH/LIFETIME"                                         
   V110 "991B18B:#X HASH/LAST12MO"                                         
   V111 "991B18C:#X HASH/LAST30DA"                                         
   V112 "991B19A:#X MARJ/LIFETIME"                                         
   V113 "991B19B:#X MARJ/LAST12MO"                                         
   V114 "991B19C:#X MARJ/LAST30DA"                                         
   V205 "9915C32:R'S BRANCH SERV"                                          
   V206 "9915C33:R XPCTS BE OFFCR"                                         
   V207 "9915C34:R XPCTS MLTR CR"                                          
   CASEID "CASE IDENTIFICATION NUMBER".                                    
                                                                           
* SPSS MISSING VALUE COMMANDS.                                             
                                                                           
* MISSING VALUES                                                           
   ALL(-9).                                                                
                                                                           
* SPSS VALUE LABELS COMMAND.                                               
                                                                           
VALUE LABELS                                                               
   V13                                                                     
   -9 "MISSING"                                                            
   1 "NE"                                                                  
   2 "NC"                                                                  
   3 "S"                                                                   
   4 "W" /                                                                 
   V130                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V131                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V132                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V49                                                                     
   -9 "MISSING"                                                            
   0 "NONE"                                                                
   1 "1 SIBLING"                                                           
   2 "2 SIBLINGS"                                                          
   3 "3 OR MORE"/                                                          
   V101                                                                    
   -9 "MISSING"                                                            
   1 "NEVER"                                                               
   2 "1-2X"                                                                
   3 "OCCASNLY"                                                            
   4 "REG PAST"                                                            
   5 "REG NOW" /                                                           
   V102                                                                    
   -9 "MISSING"                                                            
   1 "NONE"                                                                
   2 "<1 CIG/D"                                                            
   3 "1-5/DAY"                                                             
   4 "1/2PK/D"                                                             
   5 "1 PK/DA"                                                             
   6 "1.5 PK/D"                                                            
   7 "2+ PKS/D"                                                            
   8 "INAP" /                                                              
   V103                                                                    
   -9 "MISSING"                                                            
   1 "NO"                                                                  
   2 "YES" /                                                               
   V104                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V105                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V106                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V107                                                                    
   -9 "MISSING"                                                            
   1 "NONE"                                                                
   2 "FEW"                                                                 
   3 "HALF"                                                                
   4 "MOST"                                                                
   5 "NRLY ALL" /                                                          
   V108                                                                    
   -9 "MISSING"                                                            
   1 "NONE"                                                                
   2 "ONCE"                                                                
   3 "TWICE"                                                               
   4 "3-5X"                                                                
   5 "6-9X"                                                                
   6 "10+ TIME" /                                                          
   V115                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V116                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V117                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V118                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V119                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V120                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V121                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V122                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V123                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V124                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V125                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V126                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V127                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V128                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V129                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V133                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V134                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V135                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V136                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V137                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V138                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V139                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V140                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V141                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V142                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V143                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V144                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V145                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V146                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V147                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19X"                                                              
   6 "20-39X"                                                              
   7 "40+OCCAS" /                                                          
   V148                                                                    
   -9 "MISSING"                                                            
   1 "< 18"                                                                
   2 "18+" /                                                               
   V150                                                                    
   -9 "MISSING"                                                            
   1 "MALE"                                                                
   2 "FEMALE" /                                                            
   V151                                                                    
   -9 "MISSING"                                                            
   0 "WHITE"                                                               
   1 "BLACK" /                                                             
   V152                                                                    
   -9 "MISSING"                                                            
   1 "FARM"                                                                
   2 "COUNTRY"                                                             
   3 "SML TOWN"                                                            
   4 "MED CITY"                                                            
   5 "SUBURB 4"                                                            
   6 "LRG CITY"                                                            
   7 "SUBURB 6"                                                            
   8 "VRYLG CY"                                                            
   9 "SUBURB 8" /                                                          
   V153                                                                    
   -9 "MISSING"                                                            
   1 "MARRIED"                                                             
   2 "ENGAGED"                                                             
   3 "SEP/DIV"                                                             
   4 "SINGLE" /                                                            
   V155                                                                    
   -9 "MISSING"                                                            
   0 "NT MARKD"                                                            
   1 "MARKED" /                                                            
   V156                                                                    
   -9 "MISSING"                                                            
   0 "NT MARKD"                                                            
   1 "MARKED" /                                                            
   V157                                                                    
   -9 "MISSING"                                                            
   0 "NT MARKD"                                                            
   1 "MARKED" /                                                            
   V163                                                                    
   -9 "MISSING"                                                            
   1 "GRDE SCH"                                                            
   2 "SOME HS"                                                             
   3 "HS GRAD"                                                             
   4 "SOME CLG"                                                            
   5 "CLG GRAD"                                                            
   6 "GRAD SCH" /                                                          
   V164                                                                    
   -9 "MISSING"                                                            
   1 "GRDE SCH"                                                            
   2 "SOME HS"                                                             
   3 "HS GRAD"                                                             
   4 "SOME CLG"                                                            
   5 "CLG GRAD"                                                            
   6 "GRAD SCH" /                                                          
   V165                                                                    
   -9 "MISSING"                                                            
   1 "NO"                                                                  
   2 "SOMETIME"                                                            
   3 "MOSTTIME"                                                            
   4 "ALL TIME" /                                                          
   V166                                                                    
   -9 "MISSING"                                                            
   1 "STRG GOP"                                                            
   2 "MILD GOP"                                                            
   3 "MILD DEM"                                                            
   4 "STRG DEM"                                                            
   5 "INDEPNDT"                                                            
   6 "NO PREF"                                                             
   7 "OTHER" /                                                             
   V167                                                                    
   -9 "MISSING"                                                            
   1 "VRY CONS"                                                            
   2 "CONSERV"                                                             
   3 "MODERATE"                                                            
   4 "LIBERAL"                                                             
   5 "VRY LIB"                                                             
   6 "RADICAL"/                                                            
   V169                                                                    
   -9 "MISSING"                                                            
   1 "NEVER"                                                               
   2 "RARELY"                                                              
   3 "1-2X/MO"                                                             
   4 "1/WK OR+" /                                                          
   V170                                                                    
   -9 "MISSING"                                                            
   1 "NOT IMPT"                                                            
   2 "LITL IMP"                                                            
   3 "PRTY IMP"                                                            
   4 "VERY IMP" /                                                          
   V171                                                                    
   -9 "MISSING"                                                            
   1 "BY JUNE"                                                             
   2 "JULY-JAN"                                                            
   3 "AFT JAN"                                                             
   6 "WONT" /                                                              
   V172                                                                    
   -9 "MISSING"                                                            
   1 "CLG PREP"                                                            
   2 "GENERAL"                                                             
   3 "VOC-TECH"                                                            
   4 "OTH/DK"/                                                             
   V173                                                                    
   -9 "MISSING"                                                            
   1 "FAR BLOW"                                                            
   2 "BELOW AV"                                                            
   3 "SL BELOW"                                                            
   4 "AVERAGE"                                                             
   5 "SL ABOVE"                                                            
   6 "ABOVE AV"                                                            
   7 "FAR ABOV" /                                                          
   V174                                                                    
   -9 "MISSING"                                                            
   1 "FAR BLOW"                                                            
   2 "BELOW AV"                                                            
   3 "SL BELOW"                                                            
   4 "AVERAGE"                                                             
   5 "SL ABOVE"                                                            
   6 "ABOVE AV"                                                            
   7 "FAR ABOV" /                                                          
   V175                                                                    
   -9 "MISSING"                                                            
   1 "NONE"                                                                
   2 "1 DAY"                                                               
   3 "2 DAYS"                                                              
   4 "3 DAYS"                                                              
   5 "4-5 DAYS"                                                            
   6 "6-10 DA"                                                             
   7 "11+ DAYS" /                                                          
   V176                                                                    
   -9 "MISSING"                                                            
   1 "NONE"                                                                
   2 "1 DAY"                                                               
   3 "2 DAYS"                                                              
   4 "3 DAYS"                                                              
   5 "4-5 DAYS"                                                            
   6 "6-10 DA"                                                             
   7 "11+ DAYS" /                                                          
   V177                                                                    
   -9 "MISSING"                                                            
   1 "NONE"                                                                
   2 "1 DAY"                                                               
   3 "2 DAYS"                                                              
   4 "3 DAYS"                                                              
   5 "4-5 DAYS"                                                            
   6 "6-10 DA"                                                             
   7 "11+ DAYS" /                                                          
   V178                                                                    
   -9 "MISSING"                                                            
   1 "NONE"                                                                
   2 "1-2"                                                                 
   3 "3-5"                                                                 
   4 "6-10"                                                                
   5 "11-20"                                                               
   6 "21+" /                                                               
   V179                                                                    
   -9 "MISSING"                                                            
   1 "D"                                                                   
   2 "C-"                                                                  
   3 "C"                                                                   
   4 "C+"                                                                  
   5 "B-"                                                                  
   6 "B"                                                                   
   7 "B+"                                                                  
   8 "A-"                                                                  
   9 "A" /                                                                 
   V180                                                                    
   -9 "MISSING"                                                            
   1 "DEF WONT"                                                            
   2 "PRB WONT"                                                            
   3 "PRB WILL"                                                            
   4 "DEF WILL" /                                                          
   V181                                                                    
   -9 "MISSING"                                                            
   1 "DEF WONT"                                                            
   2 "PRB WONT"                                                            
   3 "PRB WILL"                                                            
   4 "DEF WILL" /                                                          
   V182                                                                    
   -9 "MISSING"                                                            
   1 "DEF WONT"                                                            
   2 "PRB WONT"                                                            
   3 "PRB WILL"                                                            
   4 "DEF WILL" /                                                          
   V183                                                                    
   -9 "MISSING"                                                            
   1 "DEF WONT"                                                            
   2 "PRB WONT"                                                            
   3 "PRB WILL"                                                            
   4 "DEF WILL" /                                                          
   V184                                                                    
   -9 "MISSING"                                                            
   1 "DEF WONT"                                                            
   2 "PRB WONT"                                                            
   3 "PRB WILL"                                                            
   4 "DEF WILL" /                                                          
   V185                                                                    
   -9 "MISSING"                                                            
   0 "NT MARKD"                                                            
   1 "MARKED" /                                                            
   V186                                                                    
   -9 "MISSING"                                                            
   0 "NT MARKD"                                                            
   1 "MARKED" /                                                            
   V187                                                                    
   -9 "MISSING"                                                            
   0 "NT MARKD"                                                            
   1 "MARKED" /                                                            
   V188                                                                    
   -9 "MISSING"                                                            
   0 "NT MARKD"                                                            
   1 "MARKED" /                                                            
   V189                                                                    
   -9 "MISSING"                                                            
   0 "NT MARKD"                                                            
   1 "MARKED" /                                                            
   V190                                                                    
   -9 "MISSING"                                                            
   0 "NT MARKD"                                                            
   1 "MARKED" /                                                            
   V191                                                                    
   -9 "MISSING"                                                            
   1 "NONE"                                                                
   2 "5 OR <"                                                              
   3 "6-10 HRS"                                                            
   4 "11-15 HR"                                                            
   5 "16-20 HR"                                                            
   6 "21-25 HR"                                                            
   7 "26-30 HR"                                                            
   8 "30+ HRS" /                                                           
   V192                                                                    
   -9 "MISSING"                                                            
   1 "NONE"                                                                
   2 "$1-5"                                                                
   3 "$6-10"                                                               
   4 "$11-20"                                                              
   5 "$21-35"                                                              
   6 "$36-50"                                                              
   7 "$51-75"                                                              
   8 "$76-125"                                                             
   9 "$126+" /                                                             
   V193                                                                    
   -9 "MISSING"                                                            
   1 "NONE"                                                                
   2 "$1-5"                                                                
   3 "$6-10"                                                               
   4 "$11-20"                                                              
   5 "$21-35"                                                              
   6 "$36-50"                                                              
   7 "$51-75"                                                              
   8 "$76-125"                                                             
   9 "$126+" /                                                             
   V194                                                                    
   -9 "MISSING"                                                            
   1 "< 1"                                                                 
   2 "ONE"                                                                 
   3 "TWO"                                                                 
   4 "THREE"                                                               
   5 "4-5"                                                                 
   6 "6-7" /                                                               
   V195                                                                    
   -9 "MISSING"                                                            
   1 "NEVER"                                                               
   2 "1/MO OR<"                                                            
   3 "2-3/MO"                                                              
   4 "1/WK"                                                                
   5 "2-3/WK"                                                              
   6 "3+/WK" /                                                             
   V196                                                                    
   -9 "MISSING"                                                            
   1 "NONE"                                                                
   2 "1-10 MI"                                                             
   3 "11-50"                                                               
   4 "51-100"                                                              
   5 "101-200"                                                             
   6 "> 200" /                                                             
   V197                                                                    
   -9 "MISSING"                                                            
   0 "NONE"                                                                
   1 "ONE"                                                                 
   2 "TWO"                                                                 
   3 "THREE"                                                               
   4 "4+" /                                                                
   V198                                                                    
   -9 "MISSING"                                                            
   0 "None"                                                                
   1 "One"                                                                 
   2 "Two"                                                                 
   3 "3-4 or +" /                                                          
   V199                                                                    
   -9 "MISSING"                                                            
   0 "None"                                                                
   1 "One"                                                                 
   2 "Two"                                                                 
   3 "3-4 or +" /                                                          
   V200                                                                    
   -9 "MISSING"                                                            
   0 "None"                                                                
   1 "One"                                                                 
   2 "Two"                                                                 
   3 "3-4 or +" /                                                          
   V201                                                                    
   -9 "MISSING"                                                            
   0 "NONE"                                                                
   1 "ONE"                                                                 
   2 "TWO"                                                                 
   3 "THREE"                                                               
   4 "4+" /                                                                
   V202                                                                    
   -9 "MISSING"                                                            
   0 "None"                                                                
   1 "One"                                                                 
   2 "Two"                                                                 
   3 "3-4 or +" /                                                          
   V203                                                                    
   -9 "MISSING"                                                            
   0 "None"                                                                
   1 "One"                                                                 
   2 "Two"                                                                 
   3 "3-4 or +" /                                                          
   V204                                                                    
   -9 "MISSING"                                                            
   0 "None"                                                                
   1 "One"                                                                 
   2 "Two"                                                                 
   3 "3-4 or +" /                                                          
   V109                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19"                                                               
   6 "20-39"                                                               
   7 "40+OCCAS" /                                                          
   V110                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19"                                                               
   6 "20-39"                                                               
   7 "40+OCCAS" /                                                          
   V111                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19"                                                               
   6 "20-39"                                                               
   7 "40+OCCAS" /                                                          
   V112                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19"                                                               
   6 "20-39"                                                               
   7 "40+OCCAS" /                                                          
   V113                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19"                                                               
   6 "20-39"                                                               
   7 "40+OCCAS" /                                                          
   V114                                                                    
   -9 "MISSING"                                                            
   1 "0 OCCAS"                                                             
   2 "1-2X"                                                                
   3 "3-5X"                                                                
   4 "6-9X"                                                                
   5 "10-19"                                                               
   6 "20-39"                                                               
   7 "40+OCCAS" /                                                          
   V205                                                                    
   -9 "MISSING"                                                            
   1 "ARMY"                                                                
   2 "NAVY"                                                                
   3 "MARINES"                                                             
   4 "AIRFORCE"                                                            
   5 "COAST GD"                                                            
   6 "UNCERTN" /                                                           
   V206                                                                    
   -9 "MISSING"                                                            
   1 "NO"                                                                  
   2 "UNCERTN"                                                             
   3 "YES" /                                                               
   V207                                                                    
   -9 "MISSING"                                                            
   1 "NO"                                                                  
   2 "UNCERTN"                                                             
   3 "YES" /.                                                              
                                                                           
* Create SPSS system file.                                                 
                                                                           
* SAVE OUTFILE="spss-filename.sav".                                        
                                                                           
