/*                                                                             
               SAS DATA DEFINITION STATEMENTS FOR ICPSR 9028                   
                                                                               
            UNIFORM CRIME REPORTING PROGRAM DATA: [UNITED STATES]              
                    Supplementary Homicide Reports, 1981                       
                                                                               
                           2nd ICPSR Edition                                   
                             February 1994                                     
                                                                               
                                                                               
   Five SAS setup sections are provided for this data collection.              
   These sections are briefly described below:                                 
                                                                               
   PROC FORMAT assigns value formats to all variables which have               
   value descriptions in the codebook.  Some were abbreviated and/or           
   truncated in order to meet the SAS limitation on the number of              
   characters allowed for each value format.                                   
                                                                               
   INPUT contains the SAS statement which assigns the variable names,          
   identifies the variable type as either character or numeric, and            
   specifies the beginning and ending column locations in the data             
   file for each variable.  The file from which the raw data is being          
   read is specified in the INFILE statement.                                  
                                                                               
   FORMATS associates the SAS formats defined by the PROC FORMAT step          
   with the variables named in the INPUT statement.                            
                                                                               
   VARIABLE LABELS assigns variable labels for all variables in the            
   data file.                                                                  
                                                                               
   MISSING VALUE RECODES contains SAS program statements which                 
   convert missing values to the SAS system missing value ".".                 
                                                                               
   Users should combine and modify these sections or parts of these            
   sections to suit their specific needs.  Users will also need to             
   change the file-specification in the INFILE statement to an                 
   appropriate filename for their system.                                      
                                                                               
   PLEASE NOTE: The SAS setup sections for PROC FORMAT, FORMAT, and            
   MISSING VALUES have been 'commented out' (i.e., the section is              
   delimited by asterisks and slashes).  Remove the comment                    
   indicators from the section you wish to include in your final               
   setup.                                                                      
                                                                               
*/                                                                             
                                                                               
                                                                               
/* SAS PROC FORMAT FOR 9028                                                    
*/                                                                             
                                                                               
                                                                               
/* PROC FORMAT;                                                                
VALUE V1FMT                                                                    
     9028 ="ICPSR Study Number"                                                
     ;                                                                         
VALUE V2FMT                                                                    
     2 ="Second edition, February 1994"                                        
     ;                                                                         
VALUE V3FMT                                                                    
     7 ="Part 7: SHR 1981"                                                     
     ;                                                                         
VALUE V5FMT                                                                    
     6 ="SHR master file"                                                      
     ;                                                                         
VALUE V6FMT                                                                    
     01 ="Alabama"                                                             
     02 ="Arizona"                                                             
     03 ="Arkansas"                                                            
     04 ="California"                                                          
     05 ="Colorado"                                                            
     06 ="Connecticut"                                                         
     07 ="Delaware"                                                            
     08 ="Washington, D.C"                                                     
     09 ="Florida"                                                             
     10 ="Georgia"                                                             
     11 ="Idaho"                                                               
     12 ="Illinois"                                                            
     13 ="Indiana"                                                             
     14 ="Iowa"                                                                
     15 ="Kansas"                                                              
     16 ="Kentucky"                                                            
     17 ="Louisiana"                                                           
     18 ="Maine"                                                               
     19 ="Maryland"                                                            
     20 ="Massachusetts"                                                       
     21 ="Michigan"                                                            
     22 ="Minnesota"                                                           
     23 ="Mississippi"                                                         
     24 ="Missouri"                                                            
     25 ="Montana"                                                             
     26 ="Nebraska"                                                            
     27 ="Nevada"                                                              
     28 ="New Hampshire"                                                       
     29 ="New Jersey"                                                          
     30 ="New Mexico"                                                          
     31 ="New York"                                                            
     32 ="North Carolina"                                                      
     33 ="North Dakota"                                                        
     34 ="Ohio"                                                                
     35 ="Oklahoma"                                                            
     36 ="Oregon"                                                              
     37 ="Pennsylvania"                                                        
     38 ="Rhode Island"                                                        
     39 ="South Carolina"                                                      
     40 ="South Dakota"                                                        
     41 ="Tennessee"                                                           
     42 ="Texas"                                                               
     43 ="Utah"                                                                
     44 ="Vermont"                                                             
     45 ="Virginia"                                                            
     46 ="Washington"                                                          
     47 ="West Virginia"                                                       
     48 ="Wisconsin"                                                           
     49 ="Wyoming"                                                             
     50 ="Alaska"                                                              
     51 ="Hawaii"                                                              
     52 ="Canal Zone"                                                          
     53 ="Puerto Rico"                                                         
     54 ="American Samoa"                                                      
     55 ="Guam"                                                                
     62 ="Virgin Islands"                                                      
     ;                                                                         
VALUE V8FMT                                                                    
     0 ="Possessions"                                                          
     11 ="All cities 1,000,000 or over"                                        
     12 ="Cities 500,000 thru 999,999"                                         
     13 ="Cities 250,000 thru 499,999"                                         
     20 ="Cities 100,000 thru 249,999"                                         
     30 ="Cities 50,000 thru 99,999"                                           
     40 ="Cities 25,000 thru 49,999"                                           
     50 ="Cities 10,000 thru 24,999"                                           
     60 ="Cities 2,500 thru 9,999"                                             
     70 ="Cities under 2,500"                                                  
     81 ="Non-MSA counties 100,000 or over"                                    
     82 ="Non-MSA counties 25,000 thru 99,999"                                 
     83 ="Non-MSA counties 10,000 thru 24,999"                                 
     84 ="Non-MSA counties under 10,000"                                       
     85 ="Non-MSA State Police"                                                
     91 ="MSA counties 100,000 or over"                                        
     92 ="MSA counties 25,000 thru 99,999"                                     
     93 ="MSA counties 10,000 thru 24,999"                                     
     94 ="MSA counties under 10,000"                                           
     95 ="MSA State Police"                                                    
     ;                                                                         
VALUE V9FMT                                                                    
     0 ="Possessions"                                                          
     1 ="New England States"                                                   
     2 ="Middle Atlantic States"                                               
     3 ="East North Central States"                                            
     4 ="West North Central States"                                            
     5 ="South Atlantic States"                                                
     6 ="East South Central States"                                            
     7 ="West South Central States"                                            
     8 ="Mountain States"                                                      
     9 ="Pacific States"                                                       
     ;                                                                         
VALUE V10FMT                                                                   
     81 ="1981"                                                                
     ;                                                                         
VALUE V11FMT                                                                   
     0 ="Unknown or not reported"                                              
     ;                                                                         
VALUE V12FMT                                                                   
     0 ="Inapplicable"                                                         
     ;                                                                         
VALUE V13FMT                                                                   
     0 ="Inapplicable"                                                         
     ;                                                                         
VALUE V14FMT                                                                   
     0 ="Non-suburban"                                                         
     1 ="Suburban"                                                             
     ;                                                                         
VALUE V17FMT                                                                   
      1 ="January"                                                             
      2 ="February"                                                            
      3 ="March"                                                               
      4 ="April"                                                               
      5 ="May"                                                                 
      6 ="June"                                                                
      7 ="July"                                                                
      8 ="August"                                                              
      9 ="September"                                                           
     10 ="October"                                                             
     11 ="November"                                                            
     12 ="December"                                                            
     ;                                                                         
VALUE V19FMT                                                                   
     0 ="Normal update"                                                        
     1 ="Adjustment"                                                           
     ;                                                                         
VALUE V20FMT                                                                   
     1 ="Murder and non-negligent manslaughter"                                
     2 ="Manslaughter by negligence"                                           
     ;                                                                         
VALUE V22FMT                                                                   
     1 ="Single victim/single offender"                                        
     2 ="Single victim/unknown offender(s)"                                    
     3 ="Single victim/multiple offenders"                                     
     4 ="Multiple victims/single offender"                                     
     5 ="Multiple victims/multiple offenders"                                  
     6 ="Multiple victims/unknown offender(s)"                                 
     ;                                                                         
VALUE V25FMT                                                                   
     100 ="Birth to 6 days old"                                                
     101 ="7 days old to 364 days old"                                         
     1 ="1 year old"                                                           
     99 ="99 years old or more"                                                
     999 ="Unknown"                                                            
     900 ="Out of Universe"                                                    
     ;                                                                         
VALUE V26FMT                                                                   
     1 ="Male"                                                                 
     2 ="Female"                                                               
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V27FMT                                                                   
     1 ="White"                                                                
     2 ="Black"                                                                
     3 ="American Indian or Alaskan Native"                                    
     4 ="Asian or Pacific Islander"                                            
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V28FMT                                                                   
     1 ="Hispanic origin"                                                      
     2 ="Not of Hispanic origin"                                               
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V29FMT                                                                   
     100 ="Birth to 6 days old"                                                
     101 ="7 days old to 364 days old"                                         
     001 ="1 year old"                                                         
     099 ="99 years old or more"                                               
     998 ="Inap, only one victim"                                              
     999 ="Unknown"                                                            
     ;                                                                         
VALUE V30FMT                                                                   
     1 ="Male"                                                                 
     2 ="Female"                                                               
     8 ="Inap, only one victim"                                                
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V31FMT                                                                   
     1 ="White"                                                                
     2 ="Black"                                                                
     3 ="American Indian or Alaskan Native"                                    
     4 ="Asian or Pacific Islander"                                            
     8 ="Inap, only one victim"                                                
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V32FMT                                                                   
     1 ="Hispanic origin"                                                      
     2 ="Not of Hispanic origin"                                               
     8 ="Inap, only one victim"                                                
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V33FMT                                                                   
     100 ="Birth to 6 days old"                                                
     101 ="7 days old to 364 days old"                                         
     001 ="1 year old"                                                         
     099 ="99 years old or more"                                               
     998 ="Inap, less than 3 victims"                                          
     999 ="Unknown"                                                            
     ;                                                                         
VALUE V34FMT                                                                   
     1 ="Male"                                                                 
     2 ="Female"                                                               
     8 ="Inap, less than 3 victims"                                            
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V35FMT                                                                   
     1 ="White"                                                                
     2 ="Black"                                                                
     3 ="American Indian or Alaskan Native"                                    
     4 ="Asian or Pacific Islander"                                            
     8 ="Inap, less than 3 victims"                                            
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V36FMT                                                                   
     1 ="Hispanic origin"                                                      
     2 ="Not of Hispanic origin"                                               
     8 ="Inap, less than 3 victims"                                            
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V37FMT                                                                   
     100 ="Birth to 6 days old"                                                
     101 ="7 days old to 364 days old"                                         
     001 ="1 year old"                                                         
     099 ="99 years old or more"                                               
     998 ="Inap, less than 4 victims"                                          
     999 ="Unknown"                                                            
     ;                                                                         
VALUE V38FMT                                                                   
     1 ="Male"                                                                 
     2 ="Female"                                                               
     8 ="Inap, less than 4 victims"                                            
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V39FMT                                                                   
     1 ="White"                                                                
     2 ="Black"                                                                
     3 ="American Indian or Alaskan Native"                                    
     4 ="Asian or Pacific Islander"                                            
     8 ="Inap, less than 4 victims"                                            
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V40FMT                                                                   
     1 ="Hispanic origin"                                                      
     2 ="Not of Hispanic origin"                                               
     8 ="Inap, less than 4 victims"                                            
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V41FMT                                                                   
     100 ="Birth to 6 days old"                                                
     101 ="7 days old to 364 days old"                                         
     001 ="1 year old"                                                         
     099 ="99 years old or more"                                               
     998 ="Inap, less than 5 victims"                                          
     999 ="Unknown"                                                            
     ;                                                                         
VALUE V42FMT                                                                   
     1 ="Male"                                                                 
     2 ="Female"                                                               
     8 ="Inap, less than 5 victims"                                            
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V43FMT                                                                   
     1 ="White"                                                                
     2 ="Black"                                                                
     3 ="American Indian or Alaskan Native"                                    
     4 ="Asian or Pacific Islander"                                            
     8 ="Inap, less than 5 victims"                                            
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V44FMT                                                                   
     1 ="Hispanic origin"                                                      
     2 ="Not of Hispanic origin"                                               
     8 ="Inap, less than 5 victims"                                            
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V45FMT                                                                   
     100 ="Birth to 6 days old"                                                
     101 ="7 days old to 364 days old"                                         
     001 ="1 year old"                                                         
     099 ="99 years old or more"                                               
     998 ="Inap, less than 6 victims"                                          
     999 ="Unknown"                                                            
     ;                                                                         
VALUE V46FMT                                                                   
     1 ="Male"                                                                 
     2 ="Female"                                                               
     8 ="Inap, less than 6 victims"                                            
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V47FMT                                                                   
     1 ="White"                                                                
     2 ="Black"                                                                
     3 ="American Indian or Alaskan Native"                                    
     4 ="Asian or Pacific Islander"                                            
     8 ="Inap, less than 6 victims"                                            
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V48FMT                                                                   
     1 ="Hispanic origin"                                                      
     2 ="Not of Hispanic origin"                                               
     8 ="Inap, less than 6 victims"                                            
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V49FMT                                                                   
     100 ="Birth to 6 days old"                                                
     101 ="7 days old to 364 days old"                                         
     001 ="1 year old"                                                         
     099 ="99 years old or more"                                               
     998 ="Inap, less than 7 victims"                                          
     999 ="Unknown"                                                            
     ;                                                                         
VALUE V50FMT                                                                   
     1 ="Male"                                                                 
     2 ="Female"                                                               
     8 ="Inap, less than 7 victims"                                            
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V51FMT                                                                   
     1 ="White"                                                                
     2 ="Black"                                                                
     3 ="American Indian or Alaskan Native"                                    
     4 ="Asian or Pacific Islander"                                            
     8 ="Inap, less than 7 victims"                                            
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V52FMT                                                                   
     1 ="Hispanic origin"                                                      
     2 ="Not of Hispanic origin"                                               
     8 ="Inap, less than 7 victims"                                            
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V53FMT                                                                   
     100 ="Birth to 6 days old"                                                
     101 ="7 days old to 364 days old"                                         
     001 ="1 year old"                                                         
     099 ="99 years old or more"                                               
     998 ="Inap, less than 8 victims"                                          
     999 ="Unknown"                                                            
     ;                                                                         
VALUE V54FMT                                                                   
     1 ="Male"                                                                 
     2 ="Female"                                                               
     8 ="Inap, less than 8 victims"                                            
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V55FMT                                                                   
     1 ="White"                                                                
     2 ="Black"                                                                
     3 ="American Indian or Alaskan Native"                                    
     4 ="Asian or Pacific Islander"                                            
     8 ="Inap, less than 8 victims"                                            
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V56FMT                                                                   
     1 ="Hispanic origin"                                                      
     2 ="Not of Hispanic origin"                                               
     8 ="Inap, less than 8 victims"                                            
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V57FMT                                                                   
     100 ="Birth to 6 days old"                                                
     101 ="7 days old to 364 days old"                                         
     001 ="1 year old"                                                         
     099 ="99 years old or more"                                               
     998 ="Inap, less than 9 victims"                                          
     999 ="Unknown"                                                            
     ;                                                                         
VALUE V58FMT                                                                   
     1 ="Male"                                                                 
     2 ="Female"                                                               
     8 ="Inap, less than 9 victims"                                            
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V59FMT                                                                   
     1 ="White"                                                                
     2 ="Black"                                                                
     3 ="American Indian or Alaskan Native"                                    
     4 ="Asian or Pacific Islander"                                            
     8 ="Inap, less than 9 victims"                                            
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V60FMT                                                                   
     1 ="Hispanic origin"                                                      
     2 ="Not of Hispanic origin"                                               
     8 ="Inap, less than 9 victims"                                            
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V61FMT                                                                   
     100 ="Birth to 6 days old"                                                
     101 ="7 days old to 364 days old"                                         
     001 ="1 year old"                                                         
     099 ="99 years old or more"                                               
     998 ="Inap, less than 10 victims"                                         
     999 ="Unknown"                                                            
     ;                                                                         
VALUE V62FMT                                                                   
     1 ="Male"                                                                 
     2 ="Female"                                                               
     8 ="Inap, less than 10 victims"                                           
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V63FMT                                                                   
     1 ="White"                                                                
     2 ="Black"                                                                
     3 ="American Indian or Alaskan Native"                                    
     4 ="Asian or Pacific Islander"                                            
     8 ="Inap, less than 10 victims"                                           
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V64FMT                                                                   
     1 ="Hispanic origin"                                                      
     2 ="Not of Hispanic origin"                                               
     8 ="Inap, less than 10 victims"                                           
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V65FMT                                                                   
     100 ="Birth to 6 days old"                                                
     101 ="7 days old to 364 days old"                                         
     001 ="1 year old"                                                         
     099 ="99 years old or more"                                               
     998 ="Inap, less than 11 victims"                                         
     999 ="Unknown"                                                            
     ;                                                                         
VALUE V66FMT                                                                   
     1 ="Male"                                                                 
     2 ="Female"                                                               
     8 ="Inap, less than 11 victims"                                           
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V67FMT                                                                   
     1 ="White"                                                                
     2 ="Black"                                                                
     3 ="American Indian or Alaskan Native"                                    
     4 ="Asian or Pacific Islander"                                            
     8 ="Inap, less than 11 victims"                                           
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V68FMT                                                                   
     1 ="Hispanic origin"                                                      
     2 ="Not of Hispanic origin"                                               
     8 ="Inap, less than 11 victims"                                           
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V69FMT                                                                   
     999 ="Age unknown"                                                        
     ;                                                                         
VALUE V70FMT                                                                   
     1 ="Male"                                                                 
     2 ="Female"                                                               
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V71FMT                                                                   
     1 ="White"                                                                
     2 ="Black"                                                                
     3 ="American Indian or Alaskan Native"                                    
     4 ="Asian or Pacific Islander"                                            
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V72FMT                                                                   
     1 ="Hispanic origin"                                                      
     2 ="Not of Hispanic origin"                                               
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V73FMT                                                                   
     11 ="Firearm, type not stated"                                            
     12 ="Handgun - pistol, revolver, etc"                                     
     13 ="Rifle"                                                               
     14 ="Shotgun"                                                             
     15 ="Other gun"                                                           
     20 ="Knife or cutting instrument"                                         
     30 ="Blunt object"                                                        
     40 ="Personal weapons"                                                    
     50 ="Poison - does not include gas"                                       
     55 ="Pushed or thrown out window"                                         
     60 ="Explosives"                                                          
     65 ="Fire"                                                                
     70 ="Narcotics or drugs"                                                  
     75 ="Drowning"                                                            
     80 ="Strangulation - hanging"                                             
     85 ="Asphyxiation - includes death by gas"                                
     90 ="Other - type of weapon not designated"                               
     ;                                                                         
VALUE V74FMT                                                                   
     01 ="Husband"                                                             
     02 ="Wife"                                                                
     03 ="Common-law husband"                                                  
     04 ="Common-law wife"                                                     
     05 ="Mother"                                                              
     06 ="Father"                                                              
     07 ="Son"                                                                 
     08 ="Daughter"                                                            
     09 ="Brother"                                                             
     10 ="Sister"                                                              
     11 ="In-law"                                                              
     12 ="Stepfather"                                                          
     13 ="Stepmother"                                                          
     14 ="Stepson"                                                             
     15 ="Stepdaughter"                                                        
     16 ="Other family"                                                        
     17 ="Neighbor"                                                            
     18 ="Acquaintance"                                                        
     19 ="Boyfriend"                                                           
     20 ="Girlfriend"                                                          
     21 ="Ex-husband"                                                          
     22 ="Ex-wife"                                                             
     23 ="Employee"                                                            
     24 ="Employer"                                                            
     25 ="Friend"                                                              
     26 ="Homosexual relationship"                                             
     27 ="Other - known to victim"                                             
     28 ="Stranger"                                                            
     99 ="Relationship not determined"                                         
     ;                                                                         
VALUE V75FMT                                                                   
     02 ="Rape"                                                                
     03 ="Robbery"                                                             
     05 ="Burglary"                                                            
     06 ="Larceny"                                                             
     07 ="Motor vehicle theft"                                                 
     09 ="Arson"                                                               
     10 ="Prostitution and commercialized vice"                                
     17 ="Other sex offense"                                                   
     32 ="Abortion"                                                            
     18 ="Narcotic drug laws"                                                  
     19 ="Gambling"                                                            
     26 ="Other - not specified"                                               
     40 ="Lover's triangle"                                                    
     41 ="Child killed by babysitter"                                          
     42 ="Brawl due to influence of alcohol"                                   
     43 ="Brawl due to influence of narcotics"                                 
     44 ="Argument over money or property"                                     
     45 ="Other arguments"                                                     
     46 ="Gangland killings"                                                   
     47 ="Juvenile gang killings"                                              
     48 ="Institutional killings"                                              
     49 ="Sniper attack"                                                       
     60 ="Other"                                                               
     70 ="All suspected felony type"                                           
     80 ="Felon killed by private citizen"                                     
     81 ="Felon killed by police"                                              
     99 ="Circumstances undetermined"                                          
     ;                                                                         
VALUE V76FMT                                                                   
     1 ="Felon attacked police officer"                                        
     2 ="Felon attacked fellow police officer"                                 
     3 ="Felon attacked a civilian"                                            
     4 ="Felon attempted flight from a crime"                                  
     5 ="Felon killed in commission of a crime"                                
     6 ="Felon resisted arrest"                                                
     7 ="Not enough information to determine"                                  
     9 ="Inap, not a justifiable homicide"                                     
     ;                                                                         
VALUE V77FMT                                                                   
     998 ="Inap, only one offender"                                            
     999 ="Unknown"                                                            
     ;                                                                         
VALUE V78FMT                                                                   
     1 ="Male"                                                                 
     2 ="Female"                                                               
     8 ="Inap, only one offender"                                              
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V79FMT                                                                   
     1 ="White"                                                                
     2 ="Black"                                                                
     3 ="American Indian or Alaskan Native"                                    
     4 ="Asian or Pacific Islander"                                            
     8 ="Inap, only one offender"                                              
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V80FMT                                                                   
     1 ="Hispanic origin"                                                      
     2 ="Not of Hispanic origin"                                               
     8 ="Inap, only one offender"                                              
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V81FMT                                                                   
     11 ="Firearm, type not stated"                                            
     12 ="Handgun - pistol, revolver, etc"                                     
     13 ="Rifle"                                                               
     14 ="Shotgun"                                                             
     15 ="Other gun"                                                           
     20 ="Knife or cutting instrument"                                         
     30 ="Blunt object"                                                        
     40 ="Personal weapons"                                                    
     50 ="Poison - does not include gas"                                       
     55 ="Pushed or thrown out window"                                         
     60 ="Explosives"                                                          
     65 ="Fire"                                                                
     70 ="Narcotics or drugs"                                                  
     75 ="Drowning"                                                            
     80 ="Strangulation - hanging"                                             
     85 ="Asphyxiation - includes death by gas"                                
     98 ="Inap, only one offender"                                             
     90 ="Other - type of weapon not designated"                               
     ;                                                                         
VALUE V82FMT                                                                   
     01 ="Husband"                                                             
     02 ="Wife"                                                                
     03 ="Common-law husband"                                                  
     04 ="Common-law wife"                                                     
     05 ="Mother"                                                              
     06 ="Father"                                                              
     07 ="Son"                                                                 
     08 ="Daughter"                                                            
     09 ="Brother"                                                             
     10 ="Sister"                                                              
     11 ="In-law"                                                              
     12 ="Stepfather"                                                          
     13 ="Stepmother"                                                          
     14 ="Stepson"                                                             
     15 ="Stepdaughter"                                                        
     16 ="Other family"                                                        
     17 ="Neighbor"                                                            
     18 ="Acquaintance"                                                        
     19 ="Boyfriend"                                                           
     20 ="Girlfriend"                                                          
     21 ="Ex-husband"                                                          
     22 ="Ex-wife"                                                             
     23 ="Employee"                                                            
     24 ="Employer"                                                            
     25 ="Friend"                                                              
     26 ="Homosexual relationship"                                             
     27 ="Other - known to victim"                                             
     28 ="Stranger"                                                            
     98 ="Inap, only one offender"                                             
     99 ="Relationship not determined"                                         
     ;                                                                         
VALUE V83FMT                                                                   
     02 ="Rape"                                                                
     03 ="Robbery"                                                             
     05 ="Burglary"                                                            
     06 ="Larceny"                                                             
     07 ="Motor vehicle theft"                                                 
     09 ="Arson"                                                               
     10 ="Prostitution and commercialized vice"                                
     17 ="Other sex offense"                                                   
     32 ="Abortion"                                                            
     18 ="Narcotic drug laws"                                                  
     19 ="Gambling"                                                            
     26 ="Other felony type - not specified"                                   
     40 ="Lover's triangle"                                                    
     41 ="Child killed by babysitter"                                          
     42 ="Brawl due to influence of alcohol"                                   
     43 ="Brawl due to influence of narcotics"                                 
     44 ="Argument over money or property"                                     
     45 ="Other arguments"                                                     
     46 ="Gangland killings"                                                   
     47 ="Juvenile gang killings"                                              
     48 ="Institutional killings"                                              
     49 ="Sniper attack"                                                       
     60 ="Other non-felony type homicide"                                      
     70 ="All suspected felony type"                                           
     80 ="Felon killed by private citizen"                                     
     81 ="Felon killed by police"                                              
     98 ="Inap, only one offender"                                             
     99 ="Circumstances undetermined"                                          
     ;                                                                         
VALUE V84FMT                                                                   
     1 ="Felon attacked police officer"                                        
     2 ="Felon attacked fellow police officer"                                 
     3 ="Felon attacked a civilian"                                            
     4 ="Felon attempted flight from a crime"                                  
     5 ="Felon killed in commission of a crime"                                
     6 ="Felon resisted arrest"                                                
     7 ="Not enough information to determine"                                  
     8 ="Inap, only one offender"                                              
     9 ="Inap, not a justifiable homicide"                                     
     ;                                                                         
VALUE V85FMT                                                                   
     998 ="Inap, less than 3 offenders"                                        
     999 ="Unknown"                                                            
     ;                                                                         
VALUE V86FMT                                                                   
     1 ="Male"                                                                 
     2 ="Female"                                                               
     8 ="Inap, less than 3 offenders"                                          
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V87FMT                                                                   
     1 ="White"                                                                
     2 ="Black"                                                                
     3 ="American Indian or Alaskan Native"                                    
     4 ="Asian or Pacific Islander"                                            
     8 ="Inap, less than 3 offenders"                                          
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V88FMT                                                                   
     1 ="Hispanic origin"                                                      
     2 ="Not of Hispanic origin"                                               
     8 ="Inap, less than 3 offenders"                                          
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V89FMT                                                                   
     11 ="Firearm, type not stated"                                            
     12 ="Handgun - pistol, revolver, etc"                                     
     13 ="Rifle"                                                               
     14 ="Shotgun"                                                             
     15 ="Other gun"                                                           
     20 ="Knife or cutting instrument"                                         
     30 ="Blunt object"                                                        
     40 ="Personal weapons"                                                    
     50 ="Poison - does not include gas"                                       
     55 ="Pushed or thrown out window"                                         
     60 ="Explosives"                                                          
     65 ="Fire"                                                                
     70 ="Narcotics or drugs"                                                  
     75 ="Drowning"                                                            
     80 ="Strangulation - hanging"                                             
     85 ="Asphyxiation - includes death by gas"                                
     98 ="Inap, less than 3 offenders"                                         
     90 ="Other - type of weapon not designated"                               
     ;                                                                         
VALUE V90FMT                                                                   
     01 ="Husband"                                                             
     02 ="Wife"                                                                
     03 ="Common-law husband"                                                  
     04 ="Common-law wife"                                                     
     05 ="Mother"                                                              
     06 ="Father"                                                              
     07 ="Son"                                                                 
     08 ="Daughter"                                                            
     09 ="Brother"                                                             
     10 ="Sister"                                                              
     11 ="In-law"                                                              
     12 ="Stepfather"                                                          
     13 ="Stepmother"                                                          
     14 ="Stepson"                                                             
     15 ="Stepdaughter"                                                        
     16 ="Other family"                                                        
     17 ="Neighbor"                                                            
     18 ="Acquaintance"                                                        
     19 ="Boyfriend"                                                           
     20 ="Girlfriend"                                                          
     21 ="Ex-husband"                                                          
     22 ="Ex-wife"                                                             
     23 ="Employee"                                                            
     24 ="Employer"                                                            
     25 ="Friend"                                                              
     26 ="Homosexual relationship"                                             
     27 ="Other - known to victim"                                             
     28 ="Stranger"                                                            
     98 ="Inap, less than 3 offenders"                                         
     99 ="Relationship not determined"                                         
     ;                                                                         
VALUE V91FMT                                                                   
     02 ="Rape"                                                                
     03 ="Robbery"                                                             
     05 ="Burglary"                                                            
     06 ="Larceny"                                                             
     07 ="Motor vehicle theft"                                                 
     09 ="Arson"                                                               
     10 ="Prostitution and commercialized vice"                                
     17 ="Other sex offense"                                                   
     32 ="Abortion"                                                            
     18 ="Narcotic drug laws"                                                  
     19 ="Gambling"                                                            
     26 ="Other felony type - not specified"                                   
     40 ="Lover's triangle"                                                    
     41 ="Child killed by babysitter"                                          
     42 ="Brawl due to influence of alcohol"                                   
     43 ="Brawl due to influence of narcotics"                                 
     44 ="Argument over money property"                                        
     45 ="Other arguments"                                                     
     46 ="Gangland killings"                                                   
     47 ="Juvenile gang killings"                                              
     48 ="Institutional killings"                                              
     49 ="Sniper attack"                                                       
     60 ="Other non-felony type homicide"                                      
     70 ="All suspected felony type"                                           
     80 ="Felon killed by private citizen"                                     
     81 ="Felon killed by police"                                              
     98 ="Inap, less than 3 offenders"                                         
     99 ="Circumstances undetermined"                                          
     ;                                                                         
VALUE V92FMT                                                                   
     1 ="Felon attacked police officer"                                        
     2 ="Felon attacked fellow police officer"                                 
     3 ="Felon attacked a civilian"                                            
     4 ="Felon attempted flight from a crime"                                  
     5 ="Felon killed in commission of a crime"                                
     6 ="Felon resisted arrest"                                                
     7 ="Not enough information to determine"                                  
     8 ="Inap, less than 3 offenders"                                          
     9 ="Inap, not a justifiable homicide"                                     
     ;                                                                         
VALUE V93FMT                                                                   
     998 ="Inap, less than 4 offenders"                                        
     999 ="Unknown"                                                            
     ;                                                                         
VALUE V94FMT                                                                   
     1 ="Male"                                                                 
     2 ="Female"                                                               
     8 ="Inap, less than 4 offenders"                                          
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V95FMT                                                                   
     1 ="White"                                                                
     2 ="Black"                                                                
     3 ="American Indian or Alaskan Native"                                    
     4 ="Asian or Pacific Islander"                                            
     8 ="Inap, less than 4 offenders"                                          
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V96FMT                                                                   
     1 ="Hispanic origin"                                                      
     2 ="Not of Hispanic origin"                                               
     8 ="Inap, less than 4 offenders"                                          
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V97FMT                                                                   
     11 ="Firearm, type not stated"                                            
     12 ="Handgun - pistol, revolver, etc"                                     
     13 ="Rifle"                                                               
     14 ="Shotgun"                                                             
     15 ="Other gun"                                                           
     20 ="Knife or cutting instrument"                                         
     30 ="Blunt object"                                                        
     40 ="Personal weapons"                                                    
     50 ="Poison - does not include gas"                                       
     55 ="Pushed or thrown out window"                                         
     60 ="Explosives"                                                          
     65 ="Fire"                                                                
     70 ="Narcotics or drugs"                                                  
     75 ="Drowning"                                                            
     80 ="Strangulation - hanging"                                             
     85 ="Asphyxiation - includes death by gas"                                
     98 ="Inap, less than 4 offenders"                                         
     90 ="Other - type of weapon not designated"                               
     ;                                                                         
VALUE V98FMT                                                                   
     01 ="Husband"                                                             
     02 ="Wife"                                                                
     03 ="Common-law husband"                                                  
     04 ="Common-law wife"                                                     
     05 ="Mother"                                                              
     06 ="Father"                                                              
     07 ="Son"                                                                 
     08 ="Daughter"                                                            
     09 ="Brother"                                                             
     10 ="Sister"                                                              
     11 ="In-law"                                                              
     12 ="Stepfather"                                                          
     13 ="Stepmother"                                                          
     14 ="Stepson"                                                             
     15 ="Stepdaughter"                                                        
     16 ="Other family"                                                        
     17 ="Neighbor"                                                            
     18 ="Acquaintance"                                                        
     19 ="Boyfriend"                                                           
     20 ="Girlfriend"                                                          
     21 ="Ex-husband"                                                          
     22 ="Ex-wife"                                                             
     23 ="Employee"                                                            
     24 ="Employer"                                                            
     25 ="Friend"                                                              
     26 ="Homosexual relationship"                                             
     27 ="Other - known to victim"                                             
     28 ="Stranger"                                                            
     98 ="Inap, less than 4 offenders"                                         
     99 ="Relationship not determined"                                         
     ;                                                                         
VALUE V99FMT                                                                   
     02 ="Rape"                                                                
     03 ="Robbery"                                                             
     05 ="Burglary"                                                            
     06 ="Larceny"                                                             
     07 ="Motor vehicle theft"                                                 
     09 ="Arson"                                                               
     10 ="Prostitution and commercialized vice"                                
     17 ="Other sex offense"                                                   
     32 ="Abortion"                                                            
     18 ="Narcotic drug laws"                                                  
     19 ="Gambling"                                                            
     26 ="Other felony type - not specified"                                   
     40 ="Lover's triangle"                                                    
     41 ="Child killed by babysitter"                                          
     42 ="Brawl due to influence of alcohol"                                   
     43 ="Brawl due to influence of narcotics"                                 
     44 ="Argument over money property"                                        
     45 ="Other arguments"                                                     
     46 ="Gangland killings"                                                   
     47 ="Juvenile gang killings"                                              
     48 ="Institutional killings"                                              
     49 ="Sniper attack"                                                       
     60 ="Other non-felony type homicide"                                      
     70 ="All suspected felony type"                                           
     80 ="Felon killed by private citizen"                                     
     81 ="Felon killed by police"                                              
     98 ="Inap, less than 4 offenders"                                         
     99 ="Circumstances undetermined"                                          
     ;                                                                         
VALUE V100FMT                                                                  
     1 ="Felon attacked police officer"                                        
     2 ="Felon attacked fellow police officer"                                 
     3 ="Felon attacked a civilian"                                            
     4 ="Felon attempted flight from a crime"                                  
     5 ="Felon killed in commission of a crime"                                
     6 ="Felon resisted arrest"                                                
     7 ="Not enough information to determine"                                  
     8 ="Inap, less than 4 offenders"                                          
     9 ="Inap, not a justifiable homicide"                                     
     ;                                                                         
VALUE V101FMT                                                                  
     998 ="Inap, less than 5 offenders"                                        
     999 ="Unknown"                                                            
     ;                                                                         
VALUE V102FMT                                                                  
     1 ="Male"                                                                 
     2 ="Female"                                                               
     8 ="Inap, less than 5 offenders"                                          
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V103FMT                                                                  
     1 ="White"                                                                
     2 ="Black"                                                                
     3 ="American Indian or Alaskan Native"                                    
     4 ="Asian or Pacific Islander"                                            
     8 ="Inap, less than 5 offenders"                                          
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V104FMT                                                                  
     1 ="Hispanic origin"                                                      
     2 ="Not of Hispanic origin"                                               
     8 ="Inap, less than 5 offenders"                                          
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V105FMT                                                                  
     11 ="Firearm, type not stated"                                            
     12 ="Handgun - pistol, revolver, etc"                                     
     13 ="Rifle"                                                               
     14 ="Shotgun"                                                             
     15 ="Other gun"                                                           
     20 ="Knife or cutting instrument"                                         
     30 ="Blunt object"                                                        
     40 ="Personal weapons"                                                    
     50 ="Poison - does not include gas"                                       
     55 ="Pushed or thrown out window"                                         
     60 ="Explosives"                                                          
     65 ="Fire"                                                                
     70 ="Narcotics or drugs"                                                  
     75 ="Drowning"                                                            
     80 ="Strangulation - hanging"                                             
     85 ="Asphyxiation - includes death by gas"                                
     98 ="Inap, less than 5 offenders"                                         
     90 ="Other - type of weapon not designated"                               
     ;                                                                         
VALUE V106FMT                                                                  
     01 ="Husband"                                                             
     02 ="Wife"                                                                
     03 ="Common-law husband"                                                  
     04 ="Common-law wife"                                                     
     05 ="Mother"                                                              
     06 ="Father"                                                              
     07 ="Son"                                                                 
     08 ="Daughter"                                                            
     09 ="Brother"                                                             
     10 ="Sister"                                                              
     11 ="In-law"                                                              
     12 ="Stepfather"                                                          
     13 ="Stepmother"                                                          
     14 ="Stepson"                                                             
     15 ="Stepdaughter"                                                        
     16 ="Other family"                                                        
     17 ="Neighbor"                                                            
     18 ="Acquaintance"                                                        
     19 ="Boyfriend"                                                           
     20 ="Girlfriend"                                                          
     21 ="Ex-husband"                                                          
     22 ="Ex-wife"                                                             
     23 ="Employee"                                                            
     24 ="Employer"                                                            
     25 ="Friend"                                                              
     26 ="Homosexual relationship"                                             
     27 ="Other - known to victim"                                             
     28 ="Stranger"                                                            
     98 ="Inap, less than 5 offenders"                                         
     99 ="Relationship not determined"                                         
     ;                                                                         
VALUE V107FMT                                                                  
     02 ="Rape"                                                                
     03 ="Robbery"                                                             
     05 ="Burglary"                                                            
     06 ="Larceny"                                                             
     07 ="Motor vehicle theft"                                                 
     09 ="Arson"                                                               
     10 ="Prostitution and commercialized vice"                                
     17 ="Other sex offense"                                                   
     32 ="Abortion"                                                            
     18 ="Narcotic drug laws"                                                  
     19 ="Gambling"                                                            
     26 ="Other felony type - not specified"                                   
     40 ="Lover's triangle"                                                    
     41 ="Child killed by babysitter"                                          
     42 ="Brawl due to influence of alcohol"                                   
     43 ="Brawl due to influence of narcotics"                                 
     44 ="Argument over money or property"                                     
     45 ="Other arguments"                                                     
     46 ="Gangland killings"                                                   
     47 ="Juvenile gang killings"                                              
     48 ="Institutional killings"                                              
     49 ="Sniper attack"                                                       
     60 ="Other non-felony type homicide"                                      
     70 ="All suspected felony type"                                           
     80 ="Felon killed by private citizen"                                     
     81 ="Felon killed by police"                                              
     98 ="Inap, less than 5 offenders"                                         
     99 ="Circumstances undetermined"                                          
     ;                                                                         
VALUE V108FMT                                                                  
     1 ="Felon attacked police officer"                                        
     2 ="Felon attacked fellow police officer"                                 
     3 ="Felon attacked a civilian"                                            
     4 ="Felon attempted flight from a crime"                                  
     5 ="Felon killed in commission of a crime"                                
     6 ="Felon resisted arrest"                                                
     7 ="Not enough information to determine"                                  
     8 ="Inap, less than 5 offenders"                                          
     9 ="Inap, not a justifiable homicide"                                     
     ;                                                                         
VALUE V109FMT                                                                  
     998 ="Inap, less than 6 offenders"                                        
     999 ="Unknown"                                                            
     ;                                                                         
VALUE V110FMT                                                                  
     1 ="Male"                                                                 
     2 ="Female"                                                               
     8 ="Inap, less than 6 offenders"                                          
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V111FMT                                                                  
     1 ="White"                                                                
     2 ="Black"                                                                
     3 ="American Indian or Alaskan Native"                                    
     4 ="Asian or Pacific Islander"                                            
     8 ="Inap, less than 6 offenders"                                          
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V112FMT                                                                  
     1 ="Hispanic origin"                                                      
     2 ="Not of Hispanic origin"                                               
     8 ="Inap, less than 6 offenders"                                          
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V113FMT                                                                  
     11 ="Firearm, type not stated"                                            
     12 ="Handgun - pistol, revolver, etc"                                     
     13 ="Rifle"                                                               
     14 ="Shotgun"                                                             
     15 ="Other gun"                                                           
     20 ="Knife or cutting instrument"                                         
     30 ="Blunt object"                                                        
     40 ="Personal weapons"                                                    
     50 ="Poison - does not include gas"                                       
     55 ="Pushed or thrown out window"                                         
     60 ="Explosives"                                                          
     65 ="Fire"                                                                
     70 ="Narcotics or drugs"                                                  
     75 ="Drowning"                                                            
     80 ="Strangulation - hanging"                                             
     85 ="Asphyxiation - includes death by gas"                                
     98 ="Inap, less than 6 offenders"                                         
     90 ="Other - type of weapon not designated"                               
     ;                                                                         
VALUE V114FMT                                                                  
     01 ="Husband"                                                             
     02 ="Wife"                                                                
     03 ="Common-law husband"                                                  
     04 ="Common-law wife"                                                     
     05 ="Mother"                                                              
     06 ="Father"                                                              
     07 ="Son"                                                                 
     08 ="Daughter"                                                            
     09 ="Brother"                                                             
     10 ="Sister"                                                              
     11 ="In-law"                                                              
     12 ="Stepfather"                                                          
     13 ="Stepmother"                                                          
     14 ="Stepson"                                                             
     15 ="Stepdaughter"                                                        
     16 ="Other family"                                                        
     17 ="Neighbor"                                                            
     18 ="Acquaintance"                                                        
     19 ="Boyfriend"                                                           
     20 ="Girlfriend"                                                          
     21 ="Ex-husband"                                                          
     22 ="Ex-wife"                                                             
     23 ="Employee"                                                            
     24 ="Employer"                                                            
     25 ="Friend"                                                              
     26 ="Homosexual relationship"                                             
     27 ="Other - known to victim"                                             
     28 ="Stranger"                                                            
     98 ="Inap, less than 6 offenders"                                         
     99 ="Relationship not determined"                                         
     ;                                                                         
VALUE V115FMT                                                                  
     02 ="Rape"                                                                
     03 ="Robbery"                                                             
     05 ="Burglary"                                                            
     06 ="Larceny"                                                             
     07 ="Motor vehicle theft"                                                 
     09 ="Arson"                                                               
     10 ="Prostitution and commercialized vice"                                
     17 ="Other sex offense"                                                   
     32 ="Abortion"                                                            
     18 ="Narcotic drug laws"                                                  
     19 ="Gambling"                                                            
     26 ="Other felony type - not specified"                                   
     40 ="Lover's triangle"                                                    
     41 ="Child killed by babysitter"                                          
     42 ="Brawl due to influence of alcohol"                                   
     43 ="Brawl due to influence of narcotics"                                 
     44 ="Argument over money or property"                                     
     45 ="Other arguments"                                                     
     46 ="Gangland killings"                                                   
     47 ="Juvenile gang killings"                                              
     48 ="Institutional killings"                                              
     49 ="Sniper attack"                                                       
     60 ="Other non-felony type homicide"                                      
     70 ="All suspected felony type"                                           
     80 ="Felon killed by private citizen"                                     
     81 ="Felon killed by police"                                              
     98 ="Inap, less than 6 offenders"                                         
     99 ="Circumstances undetermined"                                          
     ;                                                                         
VALUE V116FMT                                                                  
     1 ="Felon attacked police officer"                                        
     2 ="Felon attacked fellow police officer"                                 
     3 ="Felon attacked a civilian"                                            
     4 ="Felon attempted flight from a crime"                                  
     5 ="Felon killed in commission of a crime"                                
     6 ="Felon resisted arrest"                                                
     7 ="Not enough information to determine"                                  
     8 ="Inap, less than 6 offenders"                                          
     9 ="Inap, not a justifiable homicide"                                     
     ;                                                                         
VALUE V117FMT                                                                  
     998 ="Inap, less than 7 offenders"                                        
     999 ="Unknown"                                                            
     ;                                                                         
VALUE V118FMT                                                                  
     1 ="Male"                                                                 
     2 ="Female"                                                               
     8 ="Inap, less than 7 offenders"                                          
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V119FMT                                                                  
     1 ="White"                                                                
     2 ="Black"                                                                
     3 ="American Indian or Alaskan Native"                                    
     4 ="Asian or Pacific Islander"                                            
     8 ="Inap, less than 7 offenders"                                          
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V120FMT                                                                  
     1 ="Hispanic origin"                                                      
     2 ="Not of Hispanic origin"                                               
     8 ="Inap, less than 7 offenders"                                          
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V121FMT                                                                  
     11 ="Firearm, type not stated"                                            
     12 ="Handgun - pistol, revolver, etc"                                     
     13 ="Rifle"                                                               
     14 ="Shotgun"                                                             
     15 ="Other gun"                                                           
     20 ="Knife or cutting instrument"                                         
     30 ="Blunt object"                                                        
     40 ="Personal weapons"                                                    
     50 ="Poison - does not include gas"                                       
     55 ="Pushed or thrown out window"                                         
     60 ="Explosives"                                                          
     65 ="Fire"                                                                
     70 ="Narcotics or drugs"                                                  
     75 ="Drowning"                                                            
     80 ="Strangulation - hanging"                                             
     85 ="Asphyxiation - includes death by gas"                                
     98 ="Inap, less than 7 offenders"                                         
     90 ="Other - type of weapon not designated"                               
     ;                                                                         
VALUE V122FMT                                                                  
     01 ="Husband"                                                             
     02 ="Wife"                                                                
     03 ="Common-law husband"                                                  
     04 ="Common-law wife"                                                     
     05 ="Mother"                                                              
     06 ="Father"                                                              
     07 ="Son"                                                                 
     08 ="Daughter"                                                            
     09 ="Brother"                                                             
     10 ="Sister"                                                              
     11 ="In-law"                                                              
     12 ="Stepfather"                                                          
     13 ="Stepmother"                                                          
     14 ="Stepson"                                                             
     15 ="Stepdaughter"                                                        
     16 ="Other family"                                                        
     17 ="Neighbor"                                                            
     18 ="Acquaintance"                                                        
     19 ="Boyfriend"                                                           
     20 ="Girlfriend"                                                          
     21 ="Ex-husband"                                                          
     22 ="Ex-wife"                                                             
     23 ="Employee"                                                            
     24 ="Employer"                                                            
     25 ="Friend"                                                              
     26 ="Homosexual relationship"                                             
     27 ="Other - known to victim"                                             
     28 ="Stranger"                                                            
     98 ="Inap, less than 7 offenders"                                         
     99 ="Relationship not determined"                                         
     ;                                                                         
VALUE V123FMT                                                                  
     02 ="Rape"                                                                
     03 ="Robbery"                                                             
     05 ="Burglary"                                                            
     06 ="Larceny"                                                             
     07 ="Motor vehicle theft"                                                 
     09 ="Arson"                                                               
     10 ="Prostitution and commercialized vice"                                
     17 ="Other sex offense"                                                   
     32 ="Abortion"                                                            
     18 ="Narcotic drug laws"                                                  
     19 ="Gambling"                                                            
     26 ="Other felony type - not specified"                                   
     40 ="Lover's triangle"                                                    
     41 ="Child killed by babysitter"                                          
     42 ="Brawl due to influence of alcohol"                                   
     43 ="Brawl due to influence of narcotics"                                 
     44 ="Argument over money or property"                                     
     45 ="Other arguments"                                                     
     46 ="Gangland killings"                                                   
     47 ="Juvenile gang killings"                                              
     48 ="Institutional killings"                                              
     49 ="Sniper attack"                                                       
     60 ="Other non-felony type homicide"                                      
     70 ="All suspected felony type"                                           
     80 ="Felon killed by private citizen"                                     
     81 ="Felon killed by police"                                              
     98 ="Inap, less than 7 offenders"                                         
     99 ="Circumstances undetermined"                                          
     ;                                                                         
VALUE V124FMT                                                                  
     1 ="Felon attacked police officer"                                        
     2 ="Felon attacked fellow police officer"                                 
     3 ="Felon attacked a civilian"                                            
     4 ="Felon attempted flight from a crime"                                  
     5 ="Felon killed in commission of a crime"                                
     6 ="Felon resisted arrest"                                                
     7 ="Not enough information to determine"                                  
     8 ="Inap, less than 7 offenders"                                          
     9 ="Inap, not a justifiable homicide"                                     
     ;                                                                         
VALUE V125FMT                                                                  
     998 ="Inap, less than 8 offenders"                                        
     999 ="Unknown"                                                            
     ;                                                                         
VALUE V126FMT                                                                  
     1 ="Male"                                                                 
     2 ="Female"                                                               
     8 ="Inap, less than 8 offenders"                                          
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V127FMT                                                                  
     1 ="White"                                                                
     2 ="Black"                                                                
     3 ="American Indian or Alaskan Native"                                    
     4 ="Asian or Pacific Islander"                                            
     8 ="Inap, less than 8 offenders"                                          
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V128FMT                                                                  
     1 ="Hispanic origin"                                                      
     2 ="Not of Hispanic origin"                                               
     8 ="Inap, less than 8 offenders"                                          
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V129FMT                                                                  
     11 ="Firearm, type not stated"                                            
     12 ="Handgun - pistol, revolver, etc"                                     
     13 ="Rifle"                                                               
     14 ="Shotgun"                                                             
     15 ="Other gun"                                                           
     20 ="Knife or cutting instrument"                                         
     30 ="Blunt object"                                                        
     40 ="Personal weapons"                                                    
     50 ="Poison - does not include gas"                                       
     55 ="Pushed or thrown out window"                                         
     60 ="Explosives"                                                          
     65 ="Fire"                                                                
     70 ="Narcotics or drugs"                                                  
     75 ="Drowning"                                                            
     80 ="Strangulation - hanging"                                             
     85 ="Asphyxiation - includes death by gas"                                
     98 ="Inap, less than 8 offenders"                                         
     90 ="Other - type of weapon not designated"                               
     ;                                                                         
VALUE V130FMT                                                                  
     01 ="Husband"                                                             
     02 ="Wife"                                                                
     03 ="Common-law husband"                                                  
     04 ="Common-law wife"                                                     
     05 ="Mother"                                                              
     06 ="Father"                                                              
     07 ="Son"                                                                 
     08 ="Daughter"                                                            
     09 ="Brother"                                                             
     10 ="Sister"                                                              
     11 ="In-law"                                                              
     12 ="Stepfather"                                                          
     13 ="Stepmother"                                                          
     14 ="Stepson"                                                             
     15 ="Stepdaughter"                                                        
     16 ="Other family"                                                        
     17 ="Neighbor"                                                            
     18 ="Acquaintance"                                                        
     19 ="Boyfriend"                                                           
     20 ="Girlfriend"                                                          
     21 ="Ex-husband"                                                          
     22 ="Ex-wife"                                                             
     23 ="Employee"                                                            
     24 ="Employer"                                                            
     25 ="Friend"                                                              
     26 ="Homosexual relationship"                                             
     27 ="Other - known to victim"                                             
     28 ="Stranger"                                                            
     98 ="Inap, less than 8 offenders"                                         
     99 ="Relationship not determined"                                         
     ;                                                                         
VALUE V131FMT                                                                  
     02 ="Rape"                                                                
     03 ="Robbery"                                                             
     05 ="Burglary"                                                            
     06 ="Larceny"                                                             
     07 ="Motor vehicle theft"                                                 
     09 ="Arson"                                                               
     10 ="Prostitution and commercialized vice"                                
     17 ="Other sex offense"                                                   
     32 ="Abortion"                                                            
     18 ="Narcotic drug laws"                                                  
     19 ="Gambling"                                                            
     26 ="Other felony type - not specified"                                   
     40 ="Lover's triangle"                                                    
     41 ="Child killed by babysitter"                                          
     42 ="Brawl due to influence of alcohol"                                   
     43 ="Brawl due to influence of narcotics"                                 
     44 ="Argument over money or property"                                     
     45 ="Other arguments"                                                     
     46 ="Gangland killings"                                                   
     47 ="Juvenile gang killings"                                              
     48 ="Institutional killings"                                              
     49 ="Sniper attack"                                                       
     60 ="Other non-felony type homicide"                                      
     70 ="All suspected felony type"                                           
     80 ="Felon killed by private citizen"                                     
     81 ="Felon killed by police"                                              
     98 ="Inap, less than 8 offenders"                                         
     99 ="Circumstances undetermined"                                          
     ;                                                                         
VALUE V132FMT                                                                  
     1 ="Felon attacked police officer"                                        
     2 ="Felon attacked fellow police officer"                                 
     3 ="Felon attacked a civilian"                                            
     4 ="Felon attempted flight from a crime"                                  
     5 ="Felon killed in commission of a crime"                                
     6 ="Felon resisted arrest"                                                
     7 ="Not enough information to determine"                                  
     8 ="Inap, less than 8 offenders"                                          
     9 ="Inap, not a justifiable homicide"                                     
     ;                                                                         
VALUE V133FMT                                                                  
     998 ="Inap, less than 9 offenders"                                        
     999 ="Unknown"                                                            
     ;                                                                         
VALUE V134FMT                                                                  
     1 ="Male"                                                                 
     2 ="Female"                                                               
     8 ="Inap, less than 9 offenders"                                          
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V135FMT                                                                  
     1 ="White"                                                                
     2 ="Black"                                                                
     3 ="American Indian or Alaskan Native"                                    
     4 ="Asian or Pacific Islander"                                            
     8 ="Inap, less than 9 offenders"                                          
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V136FMT                                                                  
     1 ="Hispanic origin"                                                      
     2 ="Not of Hispanic origin"                                               
     8 ="Inap, less than 9 offenders"                                          
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V137FMT                                                                  
     11 ="Firearm, type not stated"                                            
     12 ="Handgun - pistol, revolver, etc"                                     
     13 ="Rifle"                                                               
     14 ="Shotgun"                                                             
     15 ="Other gun"                                                           
     20 ="Knife or cutting instrument"                                         
     30 ="Blunt object"                                                        
     40 ="Personal weapons"                                                    
     50 ="Poison - does not include gas"                                       
     55 ="Pushed or thrown out window"                                         
     60 ="Explosives"                                                          
     65 ="Fire"                                                                
     70 ="Narcotics or drugs"                                                  
     75 ="Drowning"                                                            
     80 ="Strangulation - hanging"                                             
     85 ="Asphyxiation - includes death by gas"                                
     98 ="Inap, less than 9 offenders"                                         
     90 ="Other - type of weapon not designated"                               
     ;                                                                         
VALUE V138FMT                                                                  
     01 ="Husband"                                                             
     02 ="Wife"                                                                
     03 ="Common-law husband"                                                  
     04 ="Common-law wife"                                                     
     05 ="Mother"                                                              
     06 ="Father"                                                              
     07 ="Son"                                                                 
     08 ="Daughter"                                                            
     09 ="Brother"                                                             
     10 ="Sister"                                                              
     11 ="In-law"                                                              
     12 ="Stepfather"                                                          
     13 ="Stepmother"                                                          
     14 ="Stepson"                                                             
     15 ="Stepdaughter"                                                        
     16 ="Other family"                                                        
     17 ="Neighbor"                                                            
     18 ="Acquaintance"                                                        
     19 ="Boyfriend"                                                           
     20 ="Girlfriend"                                                          
     21 ="Ex-husband"                                                          
     22 ="Ex-wife"                                                             
     23 ="Employee"                                                            
     24 ="Employer"                                                            
     25 ="Friend"                                                              
     26 ="Homosexual relationship"                                             
     27 ="Other - known to victim"                                             
     28 ="Stranger"                                                            
     98 ="Inap, less than 9 offenders"                                         
     99 ="Relationship not determined"                                         
     ;                                                                         
VALUE V139FMT                                                                  
     02 ="Rape"                                                                
     03 ="Robbery"                                                             
     05 ="Burglary"                                                            
     06 ="Larceny"                                                             
     07 ="Motor vehicle theft"                                                 
     09 ="Arson"                                                               
     10 ="Prostitution and commercialized vice"                                
     17 ="Other sex offense"                                                   
     32 ="Abortion"                                                            
     18 ="Narcotic drug laws"                                                  
     19 ="Gambling"                                                            
     26 ="Other felony type - not specified"                                   
     40 ="Lover's triangle"                                                    
     41 ="Child killed by babysitter"                                          
     42 ="Brawl due to influence of alcohol"                                   
     43 ="Brawl due to influence of narcotics"                                 
     44 ="Argument over money or property"                                     
     45 ="Other arguments"                                                     
     46 ="Gangland killings"                                                   
     47 ="Juvenile gang killings"                                              
     48 ="Institutional killings"                                              
     49 ="Sniper attack"                                                       
     60 ="Other non-felony type homicide"                                      
     70 ="All suspected felony type"                                           
     80 ="Felon killed by private citizen"                                     
     81 ="Felon killed by police"                                              
     98 ="Inap, less than 9 offenders"                                         
     99 ="Circumstances undetermined"                                          
     ;                                                                         
VALUE V140FMT                                                                  
     1 ="Felon attacked police officer"                                        
     2 ="Felon attacked fellow police officer"                                 
     3 ="Felon attacked a civilian"                                            
     4 ="Felon attempted flight from a crime"                                  
     5 ="Felon killed in commission of a crime"                                
     6 ="Felon resisted arrest"                                                
     7 ="Not enough information to determine"                                  
     8 ="Inap, less than 9 offenders"                                          
     9 ="Inap, not a justifiable homicide"                                     
     ;                                                                         
VALUE V141FMT                                                                  
     998 ="Inap, less than 10 offenders"                                       
     999 ="Unknown"                                                            
     ;                                                                         
VALUE V142FMT                                                                  
     1 ="Male"                                                                 
     2 ="Female"                                                               
     8 ="Inap, less than 10 offenders"                                         
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V143FMT                                                                  
     1 ="White"                                                                
     2 ="Black"                                                                
     3 ="American Indian or Alaskan Native"                                    
     4 ="Asian or Pacific Islander"                                            
     8 ="Inap, less than 10 offenders"                                         
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V144FMT                                                                  
     1 ="Hispanic origin"                                                      
     2 ="Not of Hispanic origin"                                               
     8 ="Inap, less than 10 offenders"                                         
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V145FMT                                                                  
     11 ="Firearm, type not stated"                                            
     12 ="Handgun - pistol, revolver, etc"                                     
     13 ="Rifle"                                                               
     14 ="Shotgun"                                                             
     15 ="Other gun"                                                           
     20 ="Knife or cutting instrument"                                         
     30 ="Blunt object"                                                        
     40 ="Personal weapons"                                                    
     50 ="Poison - does not include gas"                                       
     55 ="Pushed or thrown out window"                                         
     60 ="Explosives"                                                          
     65 ="Fire"                                                                
     70 ="Narcotics or drugs"                                                  
     75 ="Drowning"                                                            
     80 ="Strangulation - hanging"                                             
     85 ="Asphyxiation - includes death by gas"                                
     98 ="Inap, less than 10 offenders"                                        
     90 ="Other - type of weapon not designated"                               
     ;                                                                         
VALUE V146FMT                                                                  
     01 ="Husband"                                                             
     02 ="Wife"                                                                
     03 ="Common-law husband"                                                  
     04 ="Common-law wife"                                                     
     05 ="Mother"                                                              
     06 ="Father"                                                              
     07 ="Son"                                                                 
     08 ="Daughter"                                                            
     09 ="Brother"                                                             
     10 ="Sister"                                                              
     11 ="In-law"                                                              
     12 ="Stepfather"                                                          
     13 ="Stepmother"                                                          
     14 ="Stepson"                                                             
     15 ="Stepdaughter"                                                        
     16 ="Other family"                                                        
     17 ="Neighbor"                                                            
     18 ="Acquaintance"                                                        
     19 ="Boyfriend"                                                           
     20 ="Girlfriend"                                                          
     21 ="Ex-husband"                                                          
     22 ="Ex-wife"                                                             
     23 ="Employee"                                                            
     24 ="Employer"                                                            
     25 ="Friend"                                                              
     26 ="Homosexual relationship"                                             
     27 ="Other - known to victim"                                             
     28 ="Stranger"                                                            
     98 ="Inap, less than 10 offenders"                                        
     99 ="Relationship not determined"                                         
     ;                                                                         
VALUE V147FMT                                                                  
     02 ="Rape"                                                                
     03 ="Robbery"                                                             
     05 ="Burglary"                                                            
     06 ="Larceny"                                                             
     07 ="Motor vehicle theft"                                                 
     09 ="Arson"                                                               
     10 ="Prostitution and commercialized vice"                                
     17 ="Other sex offense"                                                   
     32 ="Abortion"                                                            
     18 ="Narcotic drug laws"                                                  
     19 ="Gambling"                                                            
     26 ="Other felony type - not specified"                                   
     40 ="Lover's triangle"                                                    
     41 ="Child killed by babysitter"                                          
     42 ="Brawl due to influence of alcohol"                                   
     43 ="Brawl due to influence of narcotics"                                 
     44 ="Argument over money or property"                                     
     45 ="Other arguments"                                                     
     46 ="Gangland killings"                                                   
     47 ="Juvenile gang killings"                                              
     48 ="Institutional killings"                                              
     49 ="Sniper attack"                                                       
     60 ="Other non-felony type homicide"                                      
     70 ="All suspected felony type"                                           
     80 ="Felon killed by private citizen"                                     
     81 ="Felon killed by police"                                              
     98 ="Inap, less than 10 offenders"                                        
     99 ="Circumstances undetermined"                                          
     ;                                                                         
VALUE V148FMT                                                                  
     1 ="Felon attacked police officer"                                        
     2 ="Felon attacked fellow police officer"                                 
     3 ="Felon attacked a civilian"                                            
     4 ="Felon attempted flight from a crime"                                  
     5 ="Felon killed in commission of a crime"                                
     6 ="Felon resisted arrest"                                                
     7 ="Not enough information to determine"                                  
     8 ="Inap, less than 10 offenders"                                         
     9 ="Inap, not a justifiable homicide"                                     
     ;                                                                         
VALUE V149FMT                                                                  
     998 ="Inap, less than 11 offenders"                                       
     999 ="Unknown"                                                            
     ;                                                                         
VALUE V150FMT                                                                  
     1 ="Male"                                                                 
     2 ="Female"                                                               
     8 ="Inap, less than 11 offenders"                                         
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V151FMT                                                                  
     1 ="White"                                                                
     2 ="Black"                                                                
     3 ="American Indian or Alaskan Native"                                    
     4 ="Asian or Pacific Islander"                                            
     8 ="Inap, less than 11 offenders"                                         
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V152FMT                                                                  
     1 ="Hispanic origin"                                                      
     2 ="Not of Hispanic origin"                                               
     8 ="Inap, less than 11 offenders"                                         
     9 ="Unknown"                                                              
     ;                                                                         
VALUE V153FMT                                                                  
     11 ="Firearm, type not stated"                                            
     12 ="Handgun - pistol, revolver, etc"                                     
     13 ="Rifle"                                                               
     14 ="Shotgun"                                                             
     15 ="Other gun"                                                           
     20 ="Knife or cutting instrument"                                         
     30 ="Blunt object"                                                        
     40 ="Personal weapons"                                                    
     50 ="Poison - does not include gas"                                       
     55 ="Pushed or thrown out window"                                         
     60 ="Explosives"                                                          
     65 ="Fire"                                                                
     70 ="Narcotics or drugs"                                                  
     75 ="Drowning"                                                            
     80 ="Strangulation - hanging"                                             
     85 ="Asphyxiation - includes death by gas"                                
     98 ="Inap, less than 11 offenders"                                        
     90 ="Other - type of weapon not designated"                               
     ;                                                                         
VALUE V154FMT                                                                  
     01 ="Husband"                                                             
     02 ="Wife"                                                                
     03 ="Common-law husband"                                                  
     04 ="Common-law wife"                                                     
     05 ="Mother"                                                              
     06 ="Father"                                                              
     07 ="Son"                                                                 
     08 ="Daughter"                                                            
     09 ="Brother"                                                             
     10 ="Sister"                                                              
     11 ="In-law"                                                              
     12 ="Stepfather"                                                          
     13 ="Stepmother"                                                          
     14 ="Stepson"                                                             
     15 ="Stepdaughter"                                                        
     16 ="Other family"                                                        
     17 ="Neighbor"                                                            
     18 ="Acquaintance"                                                        
     19 ="Boyfriend"                                                           
     20 ="Girlfriend"                                                          
     21 ="Ex-husband"                                                          
     22 ="Ex-wife"                                                             
     23 ="Employee"                                                            
     24 ="Employer"                                                            
     25 ="Friend"                                                              
     26 ="Homosexual relationship"                                             
     27 ="Other - known to victim"                                             
     28 ="Stranger"                                                            
     98 ="Inap, less than 11 offenders"                                        
     99 ="Relationship not determined"                                         
     ;                                                                         
VALUE V155FMT                                                                  
     02 ="Rape"                                                                
     03 ="Robbery"                                                             
     05 ="Burglary"                                                            
     06 ="Larceny"                                                             
     07 ="Motor vehicle theft"                                                 
     09 ="Arson"                                                               
     10 ="Prostitution and commercialized vice"                                
     17 ="Other sex offense"                                                   
     32 ="Abortion"                                                            
     18 ="Narcotic drug laws"                                                  
     19 ="Gambling"                                                            
     26 ="Other felony type - not specified"                                   
     40 ="Lover's triangle"                                                    
     41 ="Child killed by babysitter"                                          
     42 ="Brawl due to influence of alcohol"                                   
     43 ="Brawl due to influence of narcotics"                                 
     44 ="Argument over money or property"                                     
     45 ="Other arguments"                                                     
     46 ="Gangland killings"                                                   
     47 ="Juvenile gang killings"                                              
     48 ="Institutional killings"                                              
     49 ="Sniper attack"                                                       
     60 ="Other non-felony type homicide"                                      
     70 ="All suspected felony type"                                           
     80 ="Felon killed by private citizen"                                     
     81 ="Felon killed by police"                                              
     98 ="Inap, less than 11 offenders"                                        
     99 ="Circumstances undetermined"                                          
     ;                                                                         
VALUE V156FMT                                                                  
     1 ="Felon attacked police officer"                                        
     2 ="Felon attacked fellow police officer"                                 
     3 ="Felon attacked a civilian"                                            
     4 ="Felon attempted flight from a crime"                                  
     5 ="Felon killed in commission of a crime"                                
     6 ="Felon resisted arrest"                                                
     7 ="Not enough information to determine"                                  
     8 ="Inap, less than 11 offenders"                                         
     9 ="Inap, not a justifiable homicide"                                     
     ;                                                                         
*/                                                                             
                                                                               
                                                                               
/* SAS INPUT FOR 9028                                                          
*/                                                                             
                                                                               
DATA ;                                                                         
INFILE 'file-specification' LRECL=295;                                         
INPUT                                                                          
V1 1-4                                                                         
V2 5                                                                           
V3 6                                                                           
V4 7-11                                                                        
V5 12                                                                          
V6 13-14                                                                       
V7 $ 15-21                                                                     
V8 22-23                                                                       
V9 24                                                                          
V10 25-26                                                                      
V11 27-33                                                                      
V12 34-36                                                                      
V13 37-39                                                                      
V14 40                                                                         
V15 $ 41-64                                                                    
V16 $ 65-70                                                                    
V17 71-72                                                                      
V18 73-78                                                                      
V19 79                                                                         
V20 80                                                                         
V21 81-83                                                                      
V22 84                                                                         
V23 85                                                                         
V24 86                                                                         
V25 87-89                                                                      
V26 90                                                                         
V27 91                                                                         
V28 92                                                                         
V29 93-95                                                                      
V30 96                                                                         
V31 97                                                                         
V32 98                                                                         
V33 99-101                                                                     
V34 102                                                                        
V35 103                                                                        
V36 104                                                                        
V37 105-107                                                                    
V38 108                                                                        
V39 109                                                                        
V40 110                                                                        
V41 111-113                                                                    
V42 114                                                                        
V43 115                                                                        
V44 116                                                                        
V45 117-119                                                                    
V46 120                                                                        
V47 121                                                                        
V48 122                                                                        
V49 123-125                                                                    
V50 126                                                                        
V51 127                                                                        
V52 128                                                                        
V53 129-131                                                                    
V54 132                                                                        
V55 133                                                                        
V56 134                                                                        
V57 135-137                                                                    
V58 138                                                                        
V59 139                                                                        
V60 140                                                                        
V61 141-143                                                                    
V62 144                                                                        
V63 145                                                                        
V64 146                                                                        
V65 147-149                                                                    
V66 150                                                                        
V67 151                                                                        
V68 152                                                                        
V69 153-155                                                                    
V70 156                                                                        
V71 157                                                                        
V72 158                                                                        
V73 159-160                                                                    
V74 161-162                                                                    
V75 163-164                                                                    
V76 165                                                                        
V77 166-168                                                                    
V78 169                                                                        
V79 170                                                                        
V80 171                                                                        
V81 172-173                                                                    
V82 174-175                                                                    
V83 176-177                                                                    
V84 178                                                                        
V85 179-181                                                                    
V86 182                                                                        
V87 183                                                                        
V88 184                                                                        
V89 185-186                                                                    
V90 187-188                                                                    
V91 189-190                                                                    
V92 191                                                                        
V93 192-194                                                                    
V94 195                                                                        
V95 196                                                                        
V96 197                                                                        
V97 198-199                                                                    
V98 200-201                                                                    
V99 202-203                                                                    
V100 204                                                                       
V101 205-207                                                                   
V102 208                                                                       
V103 209                                                                       
V104 210                                                                       
V105 211-212                                                                   
V106 213-214                                                                   
V107 215-216                                                                   
V108 217                                                                       
V109 218-220                                                                   
V110 221                                                                       
V111 222                                                                       
V112 223                                                                       
V113 224-225                                                                   
V114 226-227                                                                   
V115 228-229                                                                   
V116 230                                                                       
V117 231-233                                                                   
V118 234                                                                       
V119 235                                                                       
V120 236                                                                       
V121 237-238                                                                   
V122 239-240                                                                   
V123 241-242                                                                   
V124 243                                                                       
V125 244-246                                                                   
V126 247                                                                       
V127 248                                                                       
V128 249                                                                       
V129 250-251                                                                   
V130 252-253                                                                   
V131 254-255                                                                   
V132 256                                                                       
V133 257-259                                                                   
V134 260                                                                       
V135 261                                                                       
V136 262                                                                       
V137 263-264                                                                   
V138 265-266                                                                   
V139 267-268                                                                   
V140 269                                                                       
V141 270-272                                                                   
V142 273                                                                       
V143 274                                                                       
V144 275                                                                       
V145 276-277                                                                   
V146 278-279                                                                   
V147 280-281                                                                   
V148 282                                                                       
V149 283-285                                                                   
V150 286                                                                       
V151 287                                                                       
V152 288                                                                       
V153 289-290                                                                   
V154 291-292                                                                   
V155 293-294                                                                   
V156 295 ;                                                                     
                                                                               
                                                                               
/* SAS FORMAT FOR 9028                                                         
*/                                                                             
                                                                               
/* FORMAT                                                                      
     V1        V1FMT.                                                          
     V2        V2FMT.                                                          
     V3        V3FMT.                                                          
     V5        V5FMT.                                                          
     V6        V6FMT.                                                          
     V8        V8FMT.                                                          
     V9        V9FMT.                                                          
     V10       V10FMT.                                                         
     V11       V11FMT.                                                         
     V12       V12FMT.                                                         
     V13       V13FMT.                                                         
     V14       V14FMT.                                                         
     V17       V17FMT.                                                         
     V19       V19FMT.                                                         
     V20       V20FMT.                                                         
     V22       V22FMT.                                                         
     V25       V25FMT.                                                         
     V26       V26FMT.                                                         
     V27       V27FMT.                                                         
     V28       V28FMT.                                                         
     V29       V29FMT.                                                         
     V30       V30FMT.                                                         
     V31       V31FMT.                                                         
     V32       V32FMT.                                                         
     V33       V33FMT.                                                         
     V34       V34FMT.                                                         
     V35       V35FMT.                                                         
     V36       V36FMT.                                                         
     V37       V37FMT.                                                         
     V38       V38FMT.                                                         
     V39       V39FMT.                                                         
     V40       V40FMT.                                                         
     V41       V41FMT.                                                         
     V42       V42FMT.                                                         
     V43       V43FMT.                                                         
     V44       V44FMT.                                                         
     V45       V45FMT.                                                         
     V46       V46FMT.                                                         
     V47       V47FMT.                                                         
     V48       V48FMT.                                                         
     V49       V49FMT.                                                         
     V50       V50FMT.                                                         
     V51       V51FMT.                                                         
     V52       V52FMT.                                                         
     V53       V53FMT.                                                         
     V54       V54FMT.                                                         
     V55       V55FMT.                                                         
     V56       V56FMT.                                                         
     V57       V57FMT.                                                         
     V58       V58FMT.                                                         
     V59       V59FMT.                                                         
     V60       V60FMT.                                                         
     V61       V61FMT.                                                         
     V62       V62FMT.                                                         
     V63       V63FMT.                                                         
     V64       V64FMT.                                                         
     V65       V65FMT.                                                         
     V66       V66FMT.                                                         
     V67       V67FMT.                                                         
     V68       V68FMT.                                                         
     V69       V69FMT.                                                         
     V70       V70FMT.                                                         
     V71       V71FMT.                                                         
     V72       V72FMT.                                                         
     V73       V73FMT.                                                         
     V74       V74FMT.                                                         
     V75       V75FMT.                                                         
     V76       V76FMT.                                                         
     V77       V77FMT.                                                         
     V78       V78FMT.                                                         
     V79       V79FMT.                                                         
     V80       V80FMT.                                                         
     V81       V81FMT.                                                         
     V82       V82FMT.                                                         
     V83       V83FMT.                                                         
     V84       V84FMT.                                                         
     V85       V85FMT.                                                         
     V86       V86FMT.                                                         
     V87       V87FMT.                                                         
     V88       V88FMT.                                                         
     V89       V89FMT.                                                         
     V90       V90FMT.                                                         
     V91       V91FMT.                                                         
     V92       V92FMT.                                                         
     V93       V93FMT.                                                         
     V94       V94FMT.                                                         
     V95       V95FMT.                                                         
     V96       V96FMT.                                                         
     V97       V97FMT.                                                         
     V98       V98FMT.                                                         
     V99       V99FMT.                                                         
     V100      V100FMT.                                                        
     V101      V101FMT.                                                        
     V102      V102FMT.                                                        
     V103      V103FMT.                                                        
     V104      V104FMT.                                                        
     V105      V105FMT.                                                        
     V106      V106FMT.                                                        
     V107      V107FMT.                                                        
     V108      V108FMT.                                                        
     V109      V109FMT.                                                        
     V110      V110FMT.                                                        
     V111      V111FMT.                                                        
     V112      V112FMT.                                                        
     V113      V113FMT.                                                        
     V114      V114FMT.                                                        
     V115      V115FMT.                                                        
     V116      V116FMT.                                                        
     V117      V117FMT.                                                        
     V118      V118FMT.                                                        
     V119      V119FMT.                                                        
     V120      V120FMT.                                                        
     V121      V121FMT.                                                        
     V122      V122FMT.                                                        
     V123      V123FMT.                                                        
     V124      V124FMT.                                                        
     V125      V125FMT.                                                        
     V126      V126FMT.                                                        
     V127      V127FMT.                                                        
     V128      V128FMT.                                                        
     V129      V129FMT.                                                        
     V130      V130FMT.                                                        
     V131      V131FMT.                                                        
     V132      V132FMT.                                                        
     V133      V133FMT.                                                        
     V134      V134FMT.                                                        
     V135      V135FMT.                                                        
     V136      V136FMT.                                                        
     V137      V137FMT.                                                        
     V138      V138FMT.                                                        
     V139      V139FMT.                                                        
     V140      V140FMT.                                                        
     V141      V141FMT.                                                        
     V142      V142FMT.                                                        
     V143      V143FMT.                                                        
     V144      V144FMT.                                                        
     V145      V145FMT.                                                        
     V146      V146FMT.                                                        
     V147      V147FMT.                                                        
     V148      V148FMT.                                                        
     V149      V149FMT.                                                        
     V150      V150FMT.                                                        
     V151      V151FMT.                                                        
     V152      V152FMT.                                                        
     V153      V153FMT.                                                        
     V154      V154FMT.                                                        
     V155      V155FMT.                                                        
     V156      V156FMT.                                                        
     ;                                                                         
*/                                                                             
                                                                               
                                                                               
/* SAS LABEL FOR 9028                                                          
*/                                                                             
                                                                               
LABEL                                                                          
  V1="ICPSR STUDY NUMBER"                                                      
  V2="ICPSR EDITION NUMBER"                                                    
  V3="ICPSR PART NUMBER"                                                       
  V4="ICPSR SEQ ID NUMBER"                                                     
  V5="IDENTIFIER CODE"                                                         
  V6="NUMERIC STATE CODE"                                                      
  V7="ORI CODE"                                                                
  V8="GROUP"                                                                   
  V9="GEOGRAPHIC DIVISION"                                                     
  V10="YEAR"                                                                   
  V11="POPULATION"                                                             
  V12="COUNTY"                                                                 
  V13="MSA CODE"                                                               
  V14="MSA INDICATION"                                                         
  V15="AGENCY NAME"                                                            
  V16="STATE NAME"                                                             
  V17="MONTH OF OFFENSE"                                                       
  V18="LAST UPDATE"                                                            
  V19="TYPE OF ACTION"                                                         
  V20="TYPE OF OFFENSE:HOMICIDE"                                               
  V21="INCIDENT NUMBER"                                                        
  V22="SITUATION"                                                              
  V23="VICTIM COUNT-ADDL VICTIM"                                               
  V24="OFFNDR COUNT-ADDL OFFNDR"                                               
  V25="VICTIM 1: AGE"                                                          
  V26="VICTIM 1: SEX"                                                          
  V27="VICTIM 1: RACE"                                                         
  V28="VICTIM 1: ETHNIC ORIGIN"                                                
  V29="VICTIM 2: AGE"                                                          
  V30="VICTIM 2: SEX"                                                          
  V31="VICTIM 2: RACE"                                                         
  V32="VICTIM 2: ETHNIC ORIGIN"                                                
  V33="VICTIM 3: AGE"                                                          
  V34="VICTIM 3: SEX"                                                          
  V35="VICTIM 3: RACE"                                                         
  V36="VICTIM 3: ETHNIC ORIGIN"                                                
  V37="VICTIM 4: AGE"                                                          
  V38="VICTIM 4: SEX"                                                          
  V39="VICTIM 4: RACE"                                                         
  V40="VICTIM 4: ETHNIC ORIGIN"                                                
  V41="VICTIM 5: AGE"                                                          
  V42="VICTIM 5: SEX"                                                          
  V43="VICTIM 5: RACE"                                                         
  V44="VICTIM 5: ETHNIC ORIGIN"                                                
  V45="VICTIM 6: AGE"                                                          
  V46="VICTIM 6: SEX"                                                          
  V47="VICTIM 6: RACE"                                                         
  V48="VICTIM 6: ETHNIC ORIGIN"                                                
  V49="VICTIM 7: AGE"                                                          
  V50="VICTIM 7: SEX"                                                          
  V51="VICTIM 7: RACE"                                                         
  V52="VICTIM 7: ETHNIC ORIGIN"                                                
  V53="VICTIM 8: AGE"                                                          
  V54="VICTIM 8: SEX"                                                          
  V55="VICTIM 8: RACE"                                                         
  V56="VICTIM 8: ETHNIC ORIGIN"                                                
  V57="VICTIM 9: AGE"                                                          
  V58="VICTIM 9: SEX"                                                          
  V59="VICTIM 9: RACE"                                                         
  V60="VICTIM 9: ETHNIC ORIGIN"                                                
  V61="VICTIM 10: AGE"                                                         
  V62="VICTIM 10: SEX"                                                         
  V63="VICTIM 10: RACE"                                                        
  V64="VICTIM 10: ETHNIC ORIGIN"                                               
  V65="VICTIM 11: AGE"                                                         
  V66="VICTIM 11: SEX"                                                         
  V67="VICTIM 11: RACE"                                                        
  V68="VICTIM 11: ETHNIC ORIGIN"                                               
  V69="OFFENDER 1: AGE"                                                        
  V70="OFFENDER 1: SEX"                                                        
  V71="OFFENDER 1: RACE"                                                       
  V72="OFFENDER 1: ETHNIC ORIGN"                                               
  V73="OFFENDER 1: WEAPON"                                                     
  V74="OFFENDER 1: RELATIONSHIP"                                               
  V75="OFFENDER 1: CIRCUMSTANCE"                                               
  V76="OFFENDER 1: SUBCIRCMSTNC"                                               
  V77="OFFENDER 2: AGE"                                                        
  V78="OFFENDER 2: SEX"                                                        
  V79="OFFENDER 2: RACE"                                                       
  V80="OFFENDER 2: ETHNIC ORIGN"                                               
  V81="OFFENDER 2: WEAPON"                                                     
  V82="OFFENDER 2: RELATIONSHIP"                                               
  V83="OFFENDER 2: CIRCUMSTANCE"                                               
  V84="OFFENDER 2: SUBCIRCMSTNC"                                               
  V85="OFFENDER 3: AGE"                                                        
  V86="OFFENDER 3: SEX"                                                        
  V87="OFFENDER 3: RACE"                                                       
  V88="OFFENDER 3: ETHNIC ORIGN"                                               
  V89="OFFENDER 3: WEAPON"                                                     
  V90="OFFENDER 3: RELATIONSHIP"                                               
  V91="OFFENDER 3: CIRCUMSTANCE"                                               
  V92="OFFENDER 3: SUBCIRCMSTNC"                                               
  V93="OFFENDER 4: AGE"                                                        
  V94="OFFENDER 4: SEX"                                                        
  V95="OFFENDER 4: RACE"                                                       
  V96="OFFENDER 4: ETHNIC ORIGN"                                               
  V97="OFFENDER 4: WEAPON"                                                     
  V98="OFFENDER 4: RELATIONSHIP"                                               
  V99="OFFENDER 4: CIRCUMSTANCE"                                               
  V100="OFFENDER 4: SUBCIRCMSTNC"                                              
  V101="OFFENDER 5: AGE"                                                       
  V102="OFFENDER 5: SEX"                                                       
  V103="OFFENDER 5: RACE"                                                      
  V104="OFFENDER 5: ETHNIC ORIGN"                                              
  V105="OFFENDER 5: WEAPON"                                                    
  V106="OFFENDER 5: RELATIONSHIP"                                              
  V107="OFFENDER 5: CIRCUMSTANCE"                                              
  V108="OFFENDER 5: SUBCIRCMSTNC"                                              
  V109="OFFENDER 6: AGE"                                                       
  V110="OFFENDER 6: SEX"                                                       
  V111="OFFENDER 6: RACE"                                                      
  V112="OFFENDER 6: ETHNIC ORIGN"                                              
  V113="OFFENDER 6: WEAPON"                                                    
  V114="OFFENDER 6: RELATIONSHIP"                                              
  V115="OFFENDER 6: CIRCUMSTANCE"                                              
  V116="OFFENDER 6: SUBCIRCMSTNC"                                              
  V117="OFFENDER 7: AGE"                                                       
  V118="OFFENDER 7: SEX"                                                       
  V119="OFFENDER 7: RACE"                                                      
  V120="OFFENDER 7: ETHNIC ORIGN"                                              
  V121="OFFENDER 7: WEAPON"                                                    
  V122="OFFENDER 7: RELATIONSHIP"                                              
  V123="OFFENDER 7: CIRCUMSTANCE"                                              
  V124="OFFENDER 7: SUBCIRCMSTNC"                                              
  V125="OFFENDER 8: AGE"                                                       
  V126="OFFENDER 8: SEX"                                                       
  V127="OFFENDER 8: RACE"                                                      
  V128="OFFENDER 8: ETHNIC ORIGN"                                              
  V129="OFFENDER 8: WEAPON"                                                    
  V130="OFFENDER 8: RELATIONSHIP"                                              
  V131="OFFENDER 8: CIRCUMSTANCE"                                              
  V132="OFFENDER 8: SUBCIRCMSTNC"                                              
  V133="OFFENDER 9: AGE"                                                       
  V134="OFFENDER 9: SEX"                                                       
  V135="OFFENDER 9: RACE"                                                      
  V136="OFFENDER 9: ETHNIC ORIGN"                                              
  V137="OFFENDER 9: WEAPON"                                                    
  V138="OFFENDER 9: RELATIONSHIP"                                              
  V139="OFFENDER 9: CIRCUMSTANCE"                                              
  V140="OFFENDER 9: SUBCIRCMSTNC"                                              
  V141="OFFENDER 10: AGE"                                                      
  V142="OFFENDER 10: SEX"                                                      
  V143="OFFENDER 10: RACE"                                                     
  V144="OFFENDER 10: ETHNC ORIGN"                                              
  V145="OFFENDER 10: WEAPON"                                                   
  V146="OFFENDER 10: RELATIONSHP"                                              
  V147="OFFENDER 10: CIRCUMSTANC"                                              
  V148="OFFENDER 10: SUBCRCMSTNC"                                              
  V149="OFFENDER 11: AGE"                                                      
  V150="OFFENDER 11: SEX"                                                      
  V151="OFFENDER 11: RACE"                                                     
  V152="OFFENDER 11: ETHNC ORIGN"                                              
  V153="OFFENDER 11: WEAPON"                                                   
  V154="OFFENDER 11: RELATIONSHP"                                              
  V155="OFFENDER 11: CIRCUMSTANC"                                              
  V156="OFFENDER 11: SUBCRCMSTNC"                                              
  ;                                                                            
                                                                               
                                                                               
/* SAS MISSING VALUE RECODE FOR 9028                                           
*/                                                                             
                                                                               
/*  IF V11=0 THEN V11=.;                                                       
  IF V12=0 THEN V12=.;                                                         
  IF V13=0 THEN V13=.;                                                         
  IF V25=999 THEN V25=.;                                                       
  IF V25=900 THEN V25=.;                                                       
  IF V26=9 THEN V26=.;                                                         
  IF V27=9 THEN V27=.;                                                         
  IF V28=9 THEN V28=.;                                                         
  IF V29=998 THEN V29=.;                                                       
  IF V29=999 THEN V29=.;                                                       
  IF V30=8 THEN V30=.;                                                         
  IF V30=9 THEN V30=.;                                                         
  IF V31=8 THEN V31=.;                                                         
  IF V31=9 THEN V31=.;                                                         
  IF V32=8 THEN V32=.;                                                         
  IF V32=9 THEN V32=.;                                                         
  IF V33=998 THEN V33=.;                                                       
  IF V33=999 THEN V33=.;                                                       
  IF V34=8 THEN V34=.;                                                         
  IF V34=9 THEN V34=.;                                                         
  IF V35=8 THEN V35=.;                                                         
  IF V35=9 THEN V35=.;                                                         
  IF V36=8 THEN V36=.;                                                         
  IF V36=9 THEN V36=.;                                                         
  IF V37=998 THEN V37=.;                                                       
  IF V37=999 THEN V37=.;                                                       
  IF V38=8 THEN V38=.;                                                         
  IF V38=9 THEN V38=.;                                                         
  IF V39=8 THEN V39=.;                                                         
  IF V39=9 THEN V39=.;                                                         
  IF V40=8 THEN V40=.;                                                         
  IF V40=9 THEN V40=.;                                                         
  IF V41=998 THEN V41=.;                                                       
  IF V41=999 THEN V41=.;                                                       
  IF V42=8 THEN V42=.;                                                         
  IF V42=9 THEN V42=.;                                                         
  IF V43=8 THEN V43=.;                                                         
  IF V43=9 THEN V43=.;                                                         
  IF V44=8 THEN V44=.;                                                         
  IF V44=9 THEN V44=.;                                                         
  IF V45=998 THEN V45=.;                                                       
  IF V45=999 THEN V45=.;                                                       
  IF V46=8 THEN V46=.;                                                         
  IF V46=9 THEN V46=.;                                                         
  IF V47=8 THEN V47=.;                                                         
  IF V47=9 THEN V47=.;                                                         
  IF V48=8 THEN V48=.;                                                         
  IF V48=9 THEN V48=.;                                                         
  IF V49=998 THEN V49=.;                                                       
  IF V49=999 THEN V49=.;                                                       
  IF V50=8 THEN V50=.;                                                         
  IF V50=9 THEN V50=.;                                                         
  IF V51=8 THEN V51=.;                                                         
  IF V51=9 THEN V51=.;                                                         
  IF V52=8 THEN V52=.;                                                         
  IF V52=9 THEN V52=.;                                                         
  IF V53=998 THEN V53=.;                                                       
  IF V53=999 THEN V53=.;                                                       
  IF V54=8 THEN V54=.;                                                         
  IF V54=9 THEN V54=.;                                                         
  IF V55=8 THEN V55=.;                                                         
  IF V55=9 THEN V55=.;                                                         
  IF V56=8 THEN V56=.;                                                         
  IF V56=9 THEN V56=.;                                                         
  IF V57=998 THEN V57=.;                                                       
  IF V57=999 THEN V57=.;                                                       
  IF V58=8 THEN V58=.;                                                         
  IF V58=9 THEN V58=.;                                                         
  IF V59=8 THEN V59=.;                                                         
  IF V59=9 THEN V59=.;                                                         
  IF V60=8 THEN V60=.;                                                         
  IF V60=9 THEN V60=.;                                                         
  IF V61=998 THEN V61=.;                                                       
  IF V61=999 THEN V61=.;                                                       
  IF V62=8 THEN V62=.;                                                         
  IF V62=9 THEN V62=.;                                                         
  IF V63=8 THEN V63=.;                                                         
  IF V63=9 THEN V63=.;                                                         
  IF V64=8 THEN V64=.;                                                         
  IF V64=9 THEN V64=.;                                                         
  IF V65=998 THEN V65=.;                                                       
  IF V65=999 THEN V65=.;                                                       
  IF V66=8 THEN V66=.;                                                         
  IF V66=9 THEN V66=.;                                                         
  IF V67=8 THEN V67=.;                                                         
  IF V67=9 THEN V67=.;                                                         
  IF V68=8 THEN V68=.;                                                         
  IF V68=9 THEN V68=.;                                                         
  IF V69=999 THEN V69=.;                                                       
  IF V70=9 THEN V70=.;                                                         
  IF V71=9 THEN V71=.;                                                         
  IF V72=9 THEN V72=.;                                                         
  IF V73=90 THEN V73=.;                                                        
  IF V74=99 THEN V74=.;                                                        
  IF V75=99 THEN V75=.;                                                        
  IF V76=7 THEN V76=.;                                                         
  IF V76=9 THEN V76=.;                                                         
  IF V77=998 THEN V77=.;                                                       
  IF V77=999 THEN V77=.;                                                       
  IF V78=8 THEN V78=.;                                                         
  IF V78=9 THEN V78=.;                                                         
  IF V79=8 THEN V79=.;                                                         
  IF V79=9 THEN V79=.;                                                         
  IF V80=8 THEN V80=.;                                                         
  IF V80=9 THEN V80=.;                                                         
  IF V81=98 THEN V81=.;                                                        
  IF V81=90 THEN V81=.;                                                        
  IF V82=98 THEN V82=.;                                                        
  IF V82=99 THEN V82=.;                                                        
  IF V83=98 THEN V83=.;                                                        
  IF V83=99 THEN V83=.;                                                        
  IF V84=7 THEN V84=.;                                                         
  IF V84=8 THEN V84=.;                                                         
  IF V84=9 THEN V84=.;                                                         
  IF V85=998 THEN V85=.;                                                       
  IF V85=999 THEN V85=.;                                                       
  IF V86=8 THEN V86=.;                                                         
  IF V86=9 THEN V86=.;                                                         
  IF V87=8 THEN V87=.;                                                         
  IF V87=9 THEN V87=.;                                                         
  IF V88=8 THEN V88=.;                                                         
  IF V88=9 THEN V88=.;                                                         
  IF V89=98 THEN V89=.;                                                        
  IF V89=90 THEN V89=.;                                                        
  IF V90=98 THEN V90=.;                                                        
  IF V90=99 THEN V90=.;                                                        
  IF V91=98 THEN V91=.;                                                        
  IF V91=99 THEN V91=.;                                                        
  IF V92=7 THEN V92=.;                                                         
  IF V92=8 THEN V92=.;                                                         
  IF V92=9 THEN V92=.;                                                         
  IF V93=998 THEN V93=.;                                                       
  IF V93=999 THEN V93=.;                                                       
  IF V94=8 THEN V94=.;                                                         
  IF V94=9 THEN V94=.;                                                         
  IF V95=8 THEN V95=.;                                                         
  IF V95=9 THEN V95=.;                                                         
  IF V96=8 THEN V96=.;                                                         
  IF V96=9 THEN V96=.;                                                         
  IF V97=98 THEN V97=.;                                                        
  IF V97=90 THEN V97=.;                                                        
  IF V98=98 THEN V98=.;                                                        
  IF V98=99 THEN V98=.;                                                        
  IF V99=98 THEN V99=.;                                                        
  IF V99=99 THEN V99=.;                                                        
  IF V100=7 THEN V100=.;                                                       
  IF V100=8 THEN V100=.;                                                       
  IF V100=9 THEN V100=.;                                                       
  IF V101=998 THEN V101=.;                                                     
  IF V101=999 THEN V101=.;                                                     
  IF V102=8 THEN V102=.;                                                       
  IF V102=9 THEN V102=.;                                                       
  IF V103=8 THEN V103=.;                                                       
  IF V103=9 THEN V103=.;                                                       
  IF V104=8 THEN V104=.;                                                       
  IF V104=9 THEN V104=.;                                                       
  IF V105=98 THEN V105=.;                                                      
  IF V105=90 THEN V105=.;                                                      
  IF V106=98 THEN V106=.;                                                      
  IF V106=99 THEN V106=.;                                                      
  IF V107=98 THEN V107=.;                                                      
  IF V107=99 THEN V107=.;                                                      
  IF V108=7 THEN V108=.;                                                       
  IF V108=8 THEN V108=.;                                                       
  IF V108=9 THEN V108=.;                                                       
  IF V109=998 THEN V109=.;                                                     
  IF V109=999 THEN V109=.;                                                     
  IF V110=8 THEN V110=.;                                                       
  IF V110=9 THEN V110=.;                                                       
  IF V111=8 THEN V111=.;                                                       
  IF V111=9 THEN V111=.;                                                       
  IF V112=8 THEN V112=.;                                                       
  IF V112=9 THEN V112=.;                                                       
  IF V113=98 THEN V113=.;                                                      
  IF V113=90 THEN V113=.;                                                      
  IF V114=98 THEN V114=.;                                                      
  IF V114=99 THEN V114=.;                                                      
  IF V115=98 THEN V115=.;                                                      
  IF V115=99 THEN V115=.;                                                      
  IF V116=7 THEN V116=.;                                                       
  IF V116=8 THEN V116=.;                                                       
  IF V116=9 THEN V116=.;                                                       
  IF V117=998 THEN V117=.;                                                     
  IF V117=999 THEN V117=.;                                                     
  IF V118=8 THEN V118=.;                                                       
  IF V118=9 THEN V118=.;                                                       
  IF V119=8 THEN V119=.;                                                       
  IF V119=9 THEN V119=.;                                                       
  IF V120=8 THEN V120=.;                                                       
  IF V120=9 THEN V120=.;                                                       
  IF V121=98 THEN V121=.;                                                      
  IF V121=90 THEN V121=.;                                                      
  IF V122=98 THEN V122=.;                                                      
  IF V122=99 THEN V122=.;                                                      
  IF V123=98 THEN V123=.;                                                      
  IF V123=99 THEN V123=.;                                                      
  IF V124=7 THEN V124=.;                                                       
  IF V124=8 THEN V124=.;                                                       
  IF V124=9 THEN V124=.;                                                       
  IF V125=998 THEN V125=.;                                                     
  IF V125=999 THEN V125=.;                                                     
  IF V126=8 THEN V126=.;                                                       
  IF V126=9 THEN V126=.;                                                       
  IF V127=8 THEN V127=.;                                                       
  IF V127=9 THEN V127=.;                                                       
  IF V128=8 THEN V128=.;                                                       
  IF V128=9 THEN V128=.;                                                       
  IF V129=98 THEN V129=.;                                                      
  IF V129=90 THEN V129=.;                                                      
  IF V130=98 THEN V130=.;                                                      
  IF V130=99 THEN V130=.;                                                      
  IF V131=98 THEN V131=.;                                                      
  IF V131=99 THEN V131=.;                                                      
  IF V132=7 THEN V132=.;                                                       
  IF V132=8 THEN V132=.;                                                       
  IF V132=9 THEN V132=.;                                                       
  IF V133=998 THEN V133=.;                                                     
  IF V133=999 THEN V133=.;                                                     
  IF V134=8 THEN V134=.;                                                       
  IF V134=9 THEN V134=.;                                                       
  IF V135=8 THEN V135=.;                                                       
  IF V135=9 THEN V135=.;                                                       
  IF V136=8 THEN V136=.;                                                       
  IF V136=9 THEN V136=.;                                                       
  IF V137=98 THEN V137=.;                                                      
  IF V137=90 THEN V137=.;                                                      
  IF V138=98 THEN V138=.;                                                      
  IF V138=99 THEN V138=.;                                                      
  IF V139=98 THEN V139=.;                                                      
  IF V139=99 THEN V139=.;                                                      
  IF V140=7 THEN V140=.;                                                       
  IF V140=8 THEN V140=.;                                                       
  IF V140=9 THEN V140=.;                                                       
  IF V141=998 THEN V141=.;                                                     
  IF V141=999 THEN V141=.;                                                     
  IF V142=8 THEN V142=.;                                                       
  IF V142=9 THEN V142=.;                                                       
  IF V143=8 THEN V143=.;                                                       
  IF V143=9 THEN V143=.;                                                       
  IF V144=8 THEN V144=.;                                                       
  IF V144=9 THEN V144=.;                                                       
  IF V145=98 THEN V145=.;                                                      
  IF V145=90 THEN V145=.;                                                      
  IF V146=98 THEN V146=.;                                                      
  IF V146=99 THEN V146=.;                                                      
  IF V147=98 THEN V147=.;                                                      
  IF V147=99 THEN V147=.;                                                      
  IF V148=7 THEN V148=.;                                                       
  IF V148=8 THEN V148=.;                                                       
  IF V148=9 THEN V148=.;                                                       
  IF V149=998 THEN V149=.;                                                     
  IF V149=999 THEN V149=.;                                                     
  IF V150=8 THEN V150=.;                                                       
  IF V150=9 THEN V150=.;                                                       
  IF V151=8 THEN V151=.;                                                       
  IF V151=9 THEN V151=.;                                                       
  IF V152=8 THEN V152=.;                                                       
  IF V152=9 THEN V152=.;                                                       
  IF V153=98 THEN V153=.;                                                      
  IF V153=90 THEN V153=.;                                                      
  IF V154=98 THEN V154=.;                                                      
  IF V154=99 THEN V154=.;                                                      
  IF V155=98 THEN V155=.;                                                      
  IF V155=99 THEN V155=.;                                                      
  IF V156=7 THEN V156=.;                                                       
  IF V156=8 THEN V156=.;                                                       
  IF V156=9 THEN V156=.;                                                       
*/                                                                             
                                                                               
