% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretizeDF.supervised.R
\name{discretizeDF.supervised}
\alias{discretizeDF.supervised}
\alias{discretize}
\title{Supervised Methods to Convert Continuous Variables into Categorical
Variables}
\usage{
discretizeDF.supervised(formula, data, method = "mdlp", dig.lab = 3, ...)
}
\arguments{
\item{formula}{a formula object to specify the class variable for supervised
discretization and the predictors to be discretized in the form
\code{class ~ .} or \code{class ~ predictor1 + predictor2}.}

\item{data}{a data.frame containing continuous variables to be discretized}

\item{method}{discretization method. Available are: ``"mdlp"\verb{, }"caim"`, `"cacc"`, `"ameva"`, `"chi2"`,
`"chimerge"`, `"extendedchi2"`, and `"modchi2"`.}

\item{dig.lab}{integer; number of digits used to create labels.}

\item{\dots}{Additional parameters are passed on to the implementation of
the chosen discretization method.}
}
\value{
\code{discretizeDF()} returns a discretized data.frame. Discretized
columns have an attribute \code{"discretized:breaks"} indicating the used
breaks or and \code{"discretized:method"} giving the used method.
}
\description{
This function implements several supervised methods to convert continuous
variables into a categorical variables (factor) suitable for association
rule mining and building associative classifiers. A whole data.frame is
discretized (i.e., all numeric columns are discretized).
}
\details{
\code{discretizeDF.supervised()} only implements supervised discretization.
See \code{\link[=discretizeDF]{discretizeDF()}} in package \pkg{arules} for unsupervised
discretization.
}
\examples{
data("iris")
summary(iris)

# supervised discretization using Species
iris.disc <- discretizeDF.supervised(Species ~ ., iris)
summary(iris.disc)

attributes(iris.disc$Sepal.Length)

# discretize the first few instances of iris using the same breaks as iris.disc
discretizeDF(head(iris), methods = iris.disc)

# only discretize predictors Sepal.Length and Petal.Length
iris.disc2 <- discretizeDF.supervised(Species ~ Sepal.Length + Petal.Length, iris)
head(iris.disc2)
}
\seealso{
Unsupervised discretization from \pkg{arules}:
\code{\link[=discretize]{discretize()}}, \code{\link[=discretizeDF]{discretizeDF()}}.

Details about the available supervised discretization methods from
\pkg{discretization}:
\link[discretization:mdlp]{discretization::mdlp},
\link[discretization:caim]{discretization::caim},
\link[discretization:cacc]{discretization::cacc},
\link[discretization:ameva]{discretization::ameva},
\link[discretization:chi2]{discretization::chi2},
\link[discretization:chiM]{discretization::chiM},
\link[discretization:extendChi2]{discretization::extendChi2},
\link[discretization:modChi2]{discretization::modChi2}.

Other preparation: 
\code{\link{CBA_ruleset}()},
\code{\link{mineCARs}()},
\code{\link{prepareTransactions}()},
\code{\link{transactions2DF}()}
}
\author{
Michael Hahsler
}
\concept{preparation}
\keyword{manip}
