% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warm.R
\name{weclat}
\alias{weclat}
\alias{WARM}
\alias{warm}
\alias{WECLAT}
\title{Mining Associations from Weighted Transaction Data with Eclat (WARM)}
\usage{
weclat(data, parameter = NULL, control = NULL)
}
\arguments{
\item{data}{an object that can be coerced into an object of class
\link{transactions}.}

\item{parameter}{an object of class \link{ASparameter} (default
values: \code{support = 0.1}, \code{minlen = 1L}, and \code{maxlen = 5L}) or
a named list with corresponding components.}

\item{control}{an object of class \link{AScontrol} (default values:
\code{verbose = TRUE}) or a named list with corresponding components.}
}
\value{
Returns an object of class \link{itemsets}. Note that
weighted support is returned in \link{quality} as column \code{support}.
}
\description{
Find frequent \link{itemsets} with the Eclat algorithm. This implementation uses
optimized transaction ID list joins and transaction weights to implement weighted
association rule mining (WARM).
}
\details{
Transaction weights are stored in the \link{transactions} as a column called
\code{weight} in \link{transactionInfo}.

The weighted support of an itemset is the sum of the weights of the
transactions that contain the itemset. An itemset is frequent if its
weighted support is equal or greater than the threshold specified by
\code{support} (assuming that the weights sum to one).

Note that Eclat only mines (weighted) frequent itemsets. Weighted
association rules can be created using \code{\link[=ruleInduction]{ruleInduction()}}.
}
\note{
The C code can be interrupted by \code{CTRL-C}. This is convenient but comes
at the price that the code cannot clean up its internal memory.
}
\examples{
## Example 1: SunBai data
data(SunBai)
SunBai

## weights are stored in transactionInfo
transactionInfo(SunBai)

## mine weighted support itemsets using transaction support in SunBai
s <- weclat(SunBai, parameter = list(support = 0.3),
		       control = list(verbose = TRUE))
inspect(sort(s))

## create rules using weighted support (satisfying a minimum
## weighted confidence of 90\%).
r <- ruleInduction(s, confidence = .9)
inspect(r)

## Example 2: Find association rules in weighted data
trans <-  list(
    c("A", "B", "C", "D", "E"),
    c("C", "F", "G"),
    c("A", "B"),
    c("A"),
    c("C", "F", "G", "H"),
    c("A", "G", "H")
)

weight <- c(5, 10, 6, 7, 5, 1)

## convert list to transactions
trans <-  transactions(trans)

## add weight information
transactionInfo(trans) <- data.frame(weight = weight)
inspect(trans)

## mine weighed support itemsets
s <- weclat(trans, parameter = list(support = 0.3),
		       control = list(verbose = TRUE))
inspect(sort(s))

## create association rules
r <- ruleInduction(s, confidence = .5)
inspect(r)
}
\references{
G.D. Ramkumar, S. Ranka, and S. Tsur (1998).  Weighted
Association Rules: Model and Algorithm, \emph{Proceedings of ACM SIGKDD.}
}
\seealso{
Other mining algorithms: 
\code{\link{APappearance-class}},
\code{\link{AScontrol-classes}},
\code{\link{ASparameter-classes}},
\code{\link{apriori}()},
\code{\link{eclat}()},
\code{\link{fim4r}()},
\code{\link{ruleInduction}()}

Other weighted association mining functions: 
\code{\link{SunBai}},
\code{\link{hits}()}
}
\author{
Christian Buchta
}
\concept{mining algorithms}
\concept{weighted association mining functions}
\keyword{models}
