% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abbreviate.R
\name{abbreviate}
\alias{abbreviate}
\alias{abbreviate,itemMatrix-method}
\alias{abbreviate,transactions-method}
\alias{abbreviate,rules-method}
\alias{abbreviate,itemsets-method}
\alias{abbreviate,tidLists-method}
\title{Abbreviate item labels in transactions, itemMatrix and associations}
\usage{
abbreviate(names.arg, ...)

\S4method{abbreviate}{itemMatrix}(names.arg, minlength = 4, ..., method = "both.sides")

\S4method{abbreviate}{transactions}(names.arg, minlength = 4, ..., method = "both.sides")

\S4method{abbreviate}{rules}(names.arg, minlength = 4, ..., method = "both.sides")

\S4method{abbreviate}{itemsets}(names.arg, minlength = 4, ..., method = "both.sides")

\S4method{abbreviate}{tidLists}(names.arg, minlength = 4, ..., method = "both.sides")
}
\arguments{
\item{names.arg}{an object of class \link{transactions}, \link{itemMatrix},
\link{itemsets}, \link{rules} or \link{tidLists}.}

\item{...}{further arguments passed on to the default abbreviation
function.}

\item{minlength}{number of characters allowed in abbreviation}

\item{method}{apply to level and value (both.sides)}
}
\description{
Provides the generic function and the methods to abbreviate long item labels
in transactions, associations (rules and itemsets) and transaction ID lists.
Note that \code{abbreviate()} is not a generic and this \pkg{arules} defines a
generic with the \code{\link[base:abbreviate]{base::abbreviate()}} as the default.
}
\examples{

data(Adult)
inspect(head(Adult, 1))

Adult_abbr <- abbreviate(Adult, 15)
inspect(head(Adult_abbr, 1))

}
\seealso{
\code{\link[base:abbreviate]{base::abbreviate()}}

Other associations functions: 
\code{\link{associations-class}},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{inspect}()},
\code{\link{is.closed}()},
\code{\link{is.generator}()},
\code{\link{is.maximal}()},
\code{\link{is.redundant}()},
\code{\link{is.significant}()},
\code{\link{is.superset}()},
\code{\link{itemsets-class}},
\code{\link{match}()},
\code{\link{rules-class}},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{sort}()},
\code{\link{unique}()}

Other itemMatrix and transactions functions: 
\code{\link{crossTable}()},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{hierarchy}},
\code{\link{image}()},
\code{\link{inspect}()},
\code{\link{is.superset}()},
\code{\link{itemFrequencyPlot}()},
\code{\link{itemFrequency}()},
\code{\link{itemMatrix-class}},
\code{\link{match}()},
\code{\link{merge}()},
\code{\link{random.transactions}()},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{supportingTransactions}()},
\code{\link{tidLists-class}},
\code{\link{transactions-class}},
\code{\link{unique}()}
}
\author{
Sudheer Chelluboina and Michael Hahsler based on code by Martin
Vodenicharov.
}
\concept{associations functions}
\concept{itemMatrix and transactions functions}
\keyword{manip}
