% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.eDNA_simulation}
\alias{plot.eDNA_simulation}
\title{Plot method for eDNA simulations}
\usage{
\method{plot}{eDNA_simulation}(
  x,
  y,
  response = "Cq_star",
  probs = c(0.025, 0.975),
  alpha = 0.1,
  jitter_width = 0.35,
  ...
)
}
\arguments{
\item{x}{object of class eDNA_simulation}

\item{y}{ignored}

\item{response}{the response variable to plot}

\item{probs}{the probability for plotting CIs}

\item{alpha}{the alpha value, i.e. transparancy, of the points}

\item{jitter_width}{the width of the jitter applied to the points}

\item{...}{ignored}
}
\value{
a list of ggplots
}
\description{
Plot method for eDNA simulations
}
\details{
Plot method for eDNA simulations which creates a separate plot of
the simulated CQ values by each of the variables, i.e. a plot of
the marginal distributions. Each plot is returned in a list of
gglot objects, each of which can be further augmented. By default,
the points are semi-transparant and jittered to reduce
overplotting.
}
\author{
Matt Espe
}
