% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableby.internal.R
\name{tableby.internal}
\alias{tableby.internal}
\alias{is.tableby}
\alias{is.summary.tableby}
\alias{modpval.tableby}
\alias{tests}
\alias{tests.tableby}
\alias{na.tableby}
\alias{xtfrm.tableby}
\alias{sort.tableby}
\alias{Ops.tableby}
\alias{head.tableby}
\alias{tail.tableby}
\title{Helper functions for tableby}
\usage{
is.tableby(x)

is.summary.tableby(x)

modpval.tableby(x, pdata, use.pname = FALSE)

tests(x)

\method{tests}{tableby}(x)

na.tableby(lhs = TRUE)

\method{xtfrm}{tableby}(x)

\method{sort}{tableby}(x, ...)

\method{Ops}{tableby}(e1, e2)

\method{head}{tableby}(x, n = 6L, ...)

\method{tail}{tableby}(x, n = 6L, ...)
}
\arguments{
\item{x}{A \code{tableby} object.}

\item{pdata}{A named data.frame where the first column is the by-variable names, the (optional) second is the strata value, the next is
the x variable names, the next is p-values (or some test stat), and the (optional) next column is the method name.}

\item{use.pname}{Logical, denoting whether the column name in \code{pdata} corresponding to the p-values should be used
in the output of the object.}

\item{lhs}{Logical, denoting whether to remove \code{NA}s from the first column of the data.frame (the "left-hand side")}

\item{...}{Other arguments, or a vector of indices for extracting.}

\item{e1, e2}{\code{\link{tableby}} objects, or numbers to compare them to.}

\item{n}{A single integer. See \code{\link[utils]{head}} or \code{\link[utils]{tail}} for more details}
}
\value{
\code{na.tableby} returns a subsetted version of \code{object} (with attributes). \code{Ops.tableby} returns
  a logical vector. \code{xtfrm.tableby} returns the p-values (which are ordered by \code{\link{order}} to \code{\link{sort}}).
}
\description{
A set of helper functions for \code{\link{tableby}}.
}
\details{
Logical comparisons are implemented for \code{Ops.tableby}.
}
\seealso{
\code{\link{arsenal_table}}, \code{\link{sort}}, \code{\link[utils]{head}}, \code{\link[utils]{tail}}
}
