% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write2.R
\name{write2}
\alias{write2}
\alias{write2html}
\alias{write2pdf}
\alias{write2word}
\title{write2word, write2html, write2pdf}
\usage{
write2word(object, file, ..., keep.md = FALSE)

write2pdf(object, file, ..., keep.md = FALSE)

write2html(object, file, ..., keep.md = FALSE)
}
\arguments{
\item{object}{An object whose \code{summary} output looks "good" when using \code{results='asis'} in markdown.}

\item{file}{A single character string denoting the filename for the output document.}

\item{...}{Additional arguments to be passed to \code{summary}, \code{rmarkdown::render}, etc.
One popular option is to use \code{quiet = TRUE} to suppress the command line output.}

\item{keep.md}{Logical, denoting whether to keep the intermediate \code{.md} file.}
}
\value{
\code{object} is returned invisibly, and \code{file} is written.
}
\description{
Functions to generate a word, html, or pdf document containing a single table.
}
\details{
This is (kind of) an S3 method (the real S3 method is \code{write2}),and the default
  (used for \code{\link{tableby}}, \code{\link{modelsum}}, \code{\link{freqlist}}, etc.) assumes
  that there is a \code{summary} method implemented.
  
  To generate the appropriate file type, the default uses one of \code{rmarkdown::word_document}, \code{rmarkdown::html_document},
   and \code{rmarkdown::pdf_document} to get the job done. \code{"..."} arguments are passed to these functions, too.
}
\examples{
\dontrun{
data(mockstudy)
# tableby example
tab1 <- tableby(arm ~ sex + age, data=mockstudy)
write2html(tab1, "~/ibm/trash.html")

# freqlist example
tab.ex <- table(mockstudy[, c("arm", "sex", "mdquality.s")], useNA = "ifany")
noby <- freqlist(tab.ex, na.options = "include")
write2pdf(noby, "~/ibm/trash2.pdf")

# A more complicated example
write2word(tab1, "~/ibm/trash.doc", keep.md = TRUE,
  reference_docx = mystyles.docx, # passed to rmarkdown::word_document
  quiet = TRUE, # passed to rmarkdown::render
  title = "My cool new title" # passed to summary.tableby
}
}
\author{
Ethan Heinzen, adapted from code from Krista Goergen
}
\seealso{
\code{\link[rmarkdown]{render}}, \code{\link[rmarkdown]{word_document}}, \code{\link[rmarkdown]{html_document}}, \code{\link[rmarkdown]{pdf_document}}
}

