% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install-arrow.R
\name{create_package_with_all_dependencies}
\alias{create_package_with_all_dependencies}
\title{Create a source bundle that includes all thirdparty dependencies}
\usage{
create_package_with_all_dependencies(dest_file = NULL, source_file = NULL)
}
\arguments{
\item{dest_file}{File path for the new tar.gz package. Defaults to
\code{arrow_V.V.V_with_deps.tar.gz} in the current directory (\code{V.V.V} is the version)}

\item{source_file}{File path for the input tar.gz package. Defaults to
downloading the package from CRAN (or whatever you have set as the first in
\code{getOption("repos")})}
}
\value{
The full path to \code{dest_file}, invisibly

This function is used for setting up an offline build. If it's possible to
download at build time, don't use this function. Instead, let \code{cmake}
download the required dependencies for you.
These downloaded dependencies are only used in the build if
\code{ARROW_DEPENDENCY_SOURCE} is unset, \code{BUNDLED}, or \code{AUTO}.
https://arrow.apache.org/docs/developers/cpp/building.html#offline-builds

If you're using binary packages you shouldn't need to use this function. You
should download the appropriate binary from your package repository, transfer
that to the offline computer, and install that. Any OS can create the source
bundle, but it cannot be installed on Windows. (Instead, use a standard
Windows binary package.)

Note if you're using RStudio Package Manager on Linux: If you still want to
make a source bundle with this function, make sure to set the first repo in
\code{options("repos")} to be a mirror that contains source packages (that is:
something other than the RSPM binary mirror URLs).
\subsection{Steps for an offline install with optional dependencies:}{
\subsection{Using a computer with internet access, pre-download the dependencies:}{
\itemize{
\item Install the \code{arrow} package \emph{or} run
\code{source("https://raw.githubusercontent.com/apache/arrow/main/r/R/install-arrow.R")}
\item Run \code{create_package_with_all_dependencies("my_arrow_pkg.tar.gz")}
\item Copy the newly created \code{my_arrow_pkg.tar.gz} to the computer without internet access
}
}

\subsection{On the computer without internet access, install the prepared package:}{
\itemize{
\item Install the \code{arrow} package from the copied file
\itemize{
\item \code{install.packages("my_arrow_pkg.tar.gz", dependencies = c("Depends", "Imports", "LinkingTo"))}
\item This installation will build from source, so \code{cmake} must be available
}
\item Run \code{\link[=arrow_info]{arrow_info()}} to check installed capabilities
}
}

}
}
\description{
Create a source bundle that includes all thirdparty dependencies
}
\examples{
\dontrun{
new_pkg <- create_package_with_all_dependencies()
# Note: this works when run in the same R session, but it's meant to be
# copied to a different computer.
install.packages(new_pkg, dependencies = c("Depends", "Imports", "LinkingTo"))
}
}
