% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parquet.R
\name{write_parquet}
\alias{write_parquet}
\title{Write Parquet file to disk}
\usage{
write_parquet(table, file)
}
\arguments{
\item{table}{An \link[=arrow__Table]{arrow::Table}, or an object convertible to it}

\item{file}{a file path}
}
\description{
\href{https://parquet.apache.org/}{Parquet} is a columnar storage file format.
This function enables you to write Parquet files from R.
}
\examples{
\donttest{
try({
  tf <- tempfile(fileext = ".parquet")
  on.exit(unlink(tf))
  write_parquet(tibble::tibble(x = 1:5), tf)
})
}
}
