% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compositions.R
\docType{data}
\name{Compositions}
\alias{Compositions}
\alias{icompositions}
\title{Compositions iterator}
\format{An object of class \code{R6ClassGenerator} of length 25.}
\usage{
Compositions

icompositions(n, k = NULL, descending = FALSE, skip = NULL)
}
\arguments{
\item{n}{an non-negative integer to be partitioned}

\item{k}{number of parts}

\item{descending}{an logical to use reversed lexicographical order}

\item{skip}{the number of compositions skipped}
}
\description{
This function returns a \link{Compositions} iterator for iterating
compositions of an non-negative integer \code{n} into \code{k} parts or parts of any sizes.
The iterator allows users to fetch the next partition(s) via the \code{getnext()} method.
}
\details{
The \code{Compositions} class can be initialized by using the convenient wrapper \code{icompositions} or
\preformatted{
Compositions$new(n, k = NULL, descending = FALSE)
}

\preformatted{
getnext(d = 1L, layout = NULL, drop = NULL)
collect(layout = "row")
reset()
}
\describe{
\item{d}{number of fetched arrangements}

\item{layout}{if "row", "column" or "list" is specified, the returned value would be a
"row-major" matrix, a "column-major" matrix or a list respectively}

\item{drop}{vectorize a matrix or unlist a list}
}
}
\examples{
ipart <- icompositions(4)
ipart$getnext()
ipart$getnext(2)
ipart$getnext(layout = "column", drop = FALSE)
# collect remaining compositions
ipart$collect()

library(foreach)
foreach(x = icompositions(6, 2), .combine=c) \%do\% {
  prod(x)
}
}
\seealso{
\link{compositions} for generating all compositions and \link{ncompositions} to calculate number of compositions
}
\keyword{datasets}
