% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argonSection.R
\name{argonSection}
\alias{argonSection}
\title{Create a Boostrap 4 section container}
\usage{
argonSection(..., size = NULL, status = "default", gradient = FALSE,
  separator = FALSE, separator_color = "secondary", shape = FALSE,
  cascade = FALSE)
}
\arguments{
\item{...}{Any UI element.}

\item{size}{Section size. NULL by default.}

\item{status}{Section status. See \url{https://demos.creative-tim.com/argon-design-system/docs/foundation/colors.html}.}

\item{gradient}{Section gradient effect. FALSE by default.}

\item{separator}{Section bottom separator. FALSE by default.}

\item{separator_color}{Separator color. "secondary" by default. See \url{https://demos.creative-tim.com/argon-design-system/docs/foundation/colors.html}.}

\item{shape}{Whether to include shape in the background. FALSE by default.}

\item{cascade}{Whether to enable a cascade effect. FALSE by default.}
}
\description{
Build an argon section container
}
\note{
Do not use with the argonDash package. Only for argonR.
}
\examples{
if (interactive()) {
 library(argonR)
 argonSection(
  size = "lg",
  status = "default",
  gradient = TRUE,
  separator = TRUE,
  separator_color = "white",
  shape = TRUE,
  argonColumn(
    argonRow(
      argonColumn(
        width = 6,
        argonH1(
          display = 3, 
          "ArgonR, HTML static template for R", 
          htmltools::span("completed with examples")
        ) \%>\% argonTextColor(color = "white"),
        argonLead(
          "Argon is a great free UI package based on Bootstrap 
          4 that includes the most important components and features"
        ) \%>\% argonTextColor(color = "white")
        ),
      argonColumn(
        width = 6,
        argonImage(
          src = "inst/images/imac.svg",
          floating = TRUE
        ) \%>\% argonPersp(side = "right")
        \%>\% argonBlur()
      )
      )
  )
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
