% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arfima_function.R
\name{bestModes}
\alias{bestModes}
\title{Finds the best modes of an \code{arfima} fit.}
\usage{
bestModes(object, bestn)
}
\arguments{
\item{object}{An object of class "arfima".}

\item{bestn}{The top number of modes to keep with respect to the
log-likelihood.}
}
\value{
The \code{bestn} "best" modes.
}
\description{
Finds the best modes of an \code{arfima} fit with respect to log-likelihood.
}
\details{
This is the easiest way to remove modes with lower log-likelihoods.
}
\examples{

\donttest{
set.seed(8765)
sim <- arfima.sim(1000, model = list(phi = 0.4, theta = 0.9, dfrac = 0.4))
fit <- arfima(sim, order = c(1, 0, 1), back=T)
fit
fit <- bestModes(fit, 2)
fit
}

}
\seealso{
\code{\link{arfima}}
}
\author{
JQ (Justin) Veenstra
}
\keyword{ts}
