% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start_arealDB.R
\name{start_arealDB}
\alias{start_arealDB}
\alias{setPath}
\title{Set the root path}
\usage{
start_arealDB(root = NULL, gazetteer = NULL, top = NULL, ontology = NULL)

setPath(root = NULL)
}
\arguments{
\item{root}{[\code{character(1)}]\cr path to the root directory that contains
or shall contain an areal database.}

\item{gazetteer}{[\code{character(1)}]\cr path to the gazetteer that holds
the (hierarchical) information of territorial units used in this database.}

\item{top}{[\code{character(1)}]\cr the label of the class in the
gazetteer that represents the top-most unit (e.g. country) of the areal
database that shall be started.}

\item{ontology}{[\code{list(.)}]\cr named list with the path(s) of
ontologies, where the list name identifies the variable that shall be
matched with the ontology at the path.}
}
\value{
No return value, called for the side effect of creating the
  directory structure of the new areal database and tables that contain the
  database metadata.
}
\description{
Initiate a geospatial database or register a database that exists at the root
path.
}
\details{
This is the first function that is run in a project, as it initiates
  the areal database by creating the default sub-directories and initial
  inventory tables. When a database has already been set up, this function is
  used to register that path in the options of the current R session.
}
\section{Functions}{
\itemize{
\item \code{setPath()}: deprecated way of starting an areal database

}}
\examples{
start_arealDB(root = paste0(tempdir(), "/newDB"),
              gazetteer = system.file("test_datasets/territories.rds",
                                      package = "arealDB"),
              top = "al1",
              ontology = list(var = paste0(tempdir(), "/ontology.rds")))

getOption("adb_path"); getOption("gazetteer_path")
}
