% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createGitHubRepo.R
\name{createGitHubRepo}
\alias{createGitHubRepo}
\title{Create an Empty Repository on GitHub}
\usage{
createGitHubRepo(repo, github_token = aoptions("github_token"),
  user = aoptions("user"), repoDir = NULL,
  password = aoptions("password"),
  repoDescription = aoptions("repoDescription"),
  readmeDescription = aoptions("readmeDescription"),
  response = aoptions("response"), default = FALSE, verbose = FALSE, ...)
}
\arguments{
\item{repo}{While working with a Github repository. A character denoting new GitHub repository name. White spaces will be substitued with a dash.}

\item{github_token}{While working with a Github repository. An OAuth GitHub Token created with the \link{oauth2.0_token} function. See \link{archivist-github-integration}.
Can be set globally with \code{aoptions("github_token", github_token)}.}

\item{user}{While working with a Github repository. A character denoting GitHub user name. Can be set globally with \code{aoptions("user", user)}.
See \link{archivist-github-integration}.}

\item{repoDir}{A character that specifies the directory for the Repository which is to be made. While working with GitHub Repository, this will
be the directory of the synchronized Local Repository, in which the new Local Repository will be created (is \code{NULL} then is the same as \code{repo}).}

\item{password}{While working with a Github repository. A character denoting GitHub user password. Can be set globally with \code{aoptions("password", password)}.
See \link{archivist-github-integration}.}

\item{repoDescription}{While working with a Github repository. A character specifing the new GitHub repository description.}

\item{readmeDescription}{While working with a Github repository. A character of the content of \code{README.md} file. By default a description of \link{Repository}.
Can be set globally with \code{aoptions("readmeDescription", readmeDescription)}. In order to omit 
\code{README.md} file set \code{aoptions("readmeDescription", NULL)}.}

\item{response}{A logical value. Should the GitHub API response be returned.}

\item{default}{If \code{default = TRUE} then \code{repoDir} (\code{repo}) is set as default local repository. Also the \code{user} is set as default GitHub user.}

\item{verbose}{A logical value. If TRUE then additional messages will be printed out.}

\item{...}{further arguments passed to \link{createLocalRepo} such as \code{force}.}
}
\description{
\code{createGitHubRepo} is a GitHub version of \link{createLocalRepo} and creates a new GitHub repository 
with an empty \pkg{archivist}-like \link{Repository}. It also creates a Local \code{Repository} which is git-synchronized with
new GitHub repository. 

This function is well explained on this \href{http://r-bloggers.com/r-hero-saves-backup-city-with-archivist-and-github}{http://r-bloggers.com/r-hero-saves-backup-city-with-archivist-and-github} blog post.
}
\details{
To learn more about  \code{Archivist Integration With GitHub} visit \link{agithub}.

At least one Repository must be initialized before using other functions from the \pkg{archivist.github} package. 
While working in groups, it is highly recommended to create a Repository on a shared Dropbox/GitHub folder.

All artifacts which are desired to be archived are going to be saved in the local Repository, which is an SQLite 
database stored in a file named \code{backpack}. 
After calling \code{saveToLocalRepo} function, each artifact will be archived in a \code{md5hash.rda} file. 
This file will be saved in a folder (under \code{repoDir} directory) named 
\code{gallery}. For every artifact, \code{md5hash} is a unique string of length 32 that is produced by
\link[digest]{digest} function, which uses a cryptographical MD5 hash algorithm.

To learn more about artifacts visit \link[archivist]{archivist-package}.

Created \code{backpack} database is a useful and fundamental tool for remembering artifact's 
\code{name}, \code{class}, \code{archiving date} etc. (the so called \link{Tags})
or for keeping artifact's \code{md5hash}.

Besides the \code{backpack} database, \code{gallery} folder is created in which all 
artifacts will be archived.

After every \code{saveToLocalRepo} call the database is refreshed. As a result, the artifact is available 
immediately in \code{backpack.db} database for other collaborators.
}
\note{
Bug reports and feature requests can be sent to \href{https://github.com/MarcinKosinski/archivist.github/issues}{https://github.com/MarcinKosinski/archivist.github/issues}
}
\examples{
\dontrun{
# empty GitHub Repository creation
authoriseGitHub(ClientID, ClientSecret) -> github_token
# authoriseGitHub also does: aoptions("github_token", github_token)
aoptions("user", user.name)
aoptions("password", user.password)

createGitHubRepo("Museum")
createGitHubRepo("Museum-Extras", response = TRUE)
createGitHubRepo("Gallery", readmeDescription = NULL)
createGitHubRepo("Landfill", 
repoDescription = "My models and stuff") 
createGitHubRepo("MuseumYYYY", repoDir = "Museum_YY")
createGitHubRepo("archive-test4", default = TRUE)

## artifact's archiving
przyklad <- 1:100

# archiving
archive(przyklad) -> md5hash_path

## proof that artifact is really archived
showRemoteRepo() # uses options from setGithubRepo
# let's remove przyklad
rm(przyklad)
# and load it back from md5hash_path
aread(md5hash_path)


# clone example
unlink("archive-test", recursive = TRUE)
cloneGithubRepo('https://github.com/MarcinKosinski/archive-test')
setRemoteRepo(aoptions("user"), "archive-test")
data(iris)
archive(iris)
showRemoteRepo()

}
}
\references{
More about \pkg{archivist.github} can be found on 
\href{http://marcinkosinski.github.io/archivist.github/}{marcinkosinski.github.io/archivist.github/} 
and about \pkg{archivist} in posts' history on \href{https://pbiecek.github.io/archivist/articles/posts.html}{https://pbiecek.github.io/archivist/articles/posts.html}
}
\seealso{
Other archivist.github: \code{\link{archive}},
  \code{\link{archivist.github-package}},
  \code{\link{authoriseGitHub}},
  \code{\link{cloneGitHubRepo}},
  \code{\link{deleteGitHubRepo}},
  \code{\link{pushGitHubRepo}}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
