% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloneGitHubRepo.R
\name{cloneGitHubRepo}
\alias{cloneGitHubRepo}
\title{Clone Github Repository}
\usage{
cloneGitHubRepo(repoURL, repoDir = NULL, default = FALSE, ...)
}
\arguments{
\item{repoURL}{The remote repository to clone.}

\item{repoDir}{Local directory to clone to. If \code{NULL}, by default, creates a local directory,
which corresponds to the name after last \code{/} in \code{repoURL}.}

\item{default}{Sets cloned Repository as default Local and GitHub Repository. 
If \code{default = TRUE} then \code{repoDir} (last piece of \code{repoURL}) is set as default Local Repository 
 and for GitHub repository also the \code{user} from  \code{repoURL} is set as default GitHub user).}

\item{...}{Further parameters passed to \link[git2r]{clone}.}
}
\description{
\code{cloneGitHubRepo} is a wrapper around \code{git clone} and clones GitHub Repository
into the \code{repoDir} directory.
}
\details{
To learn more about  \code{Archivist Integration With GitHub} visit \link{agithub}.
}
\note{
Bug reports and feature requests can be sent to \href{https://github.com/MarcinKosinski/archivist.github/issues}{https://github.com/MarcinKosinski/archivist.github/issues}
}
\examples{
\dontrun{

cloneGitHubRepo("https://github.com/MarcinKosinski/Museum")
cloneGitHubRepo("https://github.com/MarcinKosinski/Museum-Extra")


# empty Github Repository creation
authoriseGitHub(ClientID, ClientSecret) -> github_token
# authoriseGitHub also does: aoptions("github_token", github_token)
aoptions("user", user.name)
aoptions("password", user.password)

createEmptyGithubRepo("archive-test4")
setRemotebRepo(aoptions("name"), "archive-test4")
## artifact's archiving
example <- 1:100

# archiving
archive(example) -> md5hash_path

## proof that artifact is really archived
showRemoteRepo() # uses options from setGithubRepo
# let's remove przyklad
rm(example)
# and load it back from md5hash_path
aread(md5hash_path)


# clone example
unlink("archive-test", recursive = TRUE)
cloneGitHubRepo('https://github.com/MarcinKosinski/archive-test')
setRemoteRepo(aoptions("name"), "archive-test")
# equivalent is cloneGitHubRepo('https://github.com/MarcinKosinski/archive-test', default = TRUE)
# check if default is set with
# aoptions('repoDir'); aoptions('repo'); aoptions('user')
data(iris)
archive(iris)
showRemoteRepo()


}
}
\references{
More about \pkg{archivist.github} can be found on 
\href{http://marcinkosinski.github.io/archivist.github/}{marcinkosinski.github.io/archivist.github/} 
and about \pkg{archivist} in posts' history on \href{https://pbiecek.github.io/archivist/articles/posts.html}{https://pbiecek.github.io/archivist/articles/posts.html}
}
\seealso{
Other archivist.github: \code{\link{archive}},
  \code{\link{archivist.github-package}},
  \code{\link{authoriseGitHub}},
  \code{\link{createGitHubRepo}},
  \code{\link{deleteGitHubRepo}},
  \code{\link{pushGitHubRepo}}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
