% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/archive_write_dir.R, R/archive_write_files.R
\name{archive_write_dir}
\alias{archive_write_dir}
\alias{archive_write_files}
\title{Add files to a new archive}
\usage{
archive_write_dir(
  archive,
  dir,
  format = NULL,
  filter = NULL,
  options = character(),
  ...,
  recursive = TRUE,
  full.names = FALSE
)

archive_write_files(
  archive,
  files,
  format = NULL,
  filter = NULL,
  options = character()
)
}
\arguments{
\item{archive}{\code{character(1)} The archive filename or an \code{archive} object.}

\item{dir}{\code{character(1)} The directory of files to add.}

\item{format}{\code{character(1)} default: \code{NULL} The archive format, one of \Sexpr[stage=render, results=rd]{archive:::choices_rd(names(archive:::archive_formats()))}.}

\item{filter}{\code{character(1)} default: \code{NULL} The archive filter, one of \Sexpr[stage=render, results=rd]{archive:::choices_rd(names(archive:::archive_filters()))}.}

\item{options}{\code{character()} default: \code{character(0)} Options to pass to the filter or format.
The list of available options are documented in
options can have one of the following forms:
\itemize{
\item \code{option=value}
The option/value pair will be provided to every module.
Modules that do not accept an option with this name will
ignore it.
\item \code{option}
The option will be provided to every module with a value
of "1".
\item \code{!option}
The option will be provided to every module with a NULL
value.
\item \code{module:option=value}, \code{module:option}, \code{module:!option}
As above, but the corresponding option and value will be
provided only to modules whose name matches module.
See \href{https://www.freebsd.org/cgi/man.cgi?query=archive_read_set_options&sektion=3&format=html}{read options} for available read options
See \href{https://www.freebsd.org/cgi/man.cgi?query=archive_write_set_options&sektion=3&format=html}{write options} for available write options
}}

\item{...}{additional parameters passed to \code{base::dir}.}

\item{recursive}{logical.  Should the listing recurse into directories?}

\item{full.names}{a logical value.  If \code{TRUE}, the directory
    path is prepended to the file names to give a relative file path.
    If \code{FALSE}, the file names (rather than paths) are returned.}

\item{files}{\code{character()} One or more files to add to the archive.}
}
\value{
An 'archive' object representing the new archive (invisibly).

An 'archive' object representing the new archive (invisibly).
}
\description{
\code{archive_write_files()} adds one or more files to a new archive.
\code{archive_write_dir()} adds all the file(s) in a directory to a new archive.
}
\examples{
if (archive:::libarchive_version() > "3.2.0") {
# write some files to a directory
d <- tempfile()
dir.create(d)
old <- setwd(d)

write.csv(iris, file.path(d, "iris.csv"))
write.csv(mtcars, file.path(d, "mtcars.csv"))
write.csv(airquality, file.path(d, "airquality.csv"))

# Add some to a new archive
a <- archive_write_files("data.tar.gz", c("iris.csv", "mtcars.csv"))
setwd(old)
a

# Add all files in a directory
a <- archive_write_dir("data.zip", d)
a

unlink("data.zip")
}
}
