% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arc-raster.R
\name{arc_raster}
\alias{arc_raster}
\title{Read from an Image Server}
\usage{
arc_raster(
  x,
  xmin,
  xmax,
  ymin,
  ymax,
  bbox_crs = NULL,
  crs = sf::st_crs(x),
  width = NULL,
  height = NULL,
  format = "tiff",
  ...,
  raster_fn = NULL,
  token = arc_token()
)
}
\arguments{
\item{x}{an \code{ImageServer} as created with \code{arc_open()}.}

\item{xmin}{the minimum bounding longitude value.}

\item{xmax}{the maximum bounding longitude value.}

\item{ymin}{that minimum bounding latitude value.}

\item{ymax}{the maximum bounding latitude value.}

\item{bbox_crs}{the CRS of the values passed to \code{xmin}, \code{xmax}, \code{ymin}, and \code{ymax}.
If not specified, uses the CRS of \code{x}.}

\item{crs}{the CRS of the resultant raster image and the provided bounding box defined by \code{xmin}, \code{xmax}, \code{ymin}, \code{ymax} (passed \code{outSR} query parameter).}

\item{width}{default \code{NULL}. Cannot exceed \code{x[["maxImageWidth"]]}.}

\item{height}{default \code{NULL}. Cannot exceed \code{x[["maxImageHeight"]]}.}

\item{format}{default \code{"tiff"}. Must be one of "jpgpng", "png", "png8", "png24", "jpg", "bmp", "gif", "tiff", "png32", "bip", "bsq", "lerc".}

\item{...}{additional key value pairs to be passed to \code{\link[httr2:req_body]{httr2::req_body_form()}}.}

\item{raster_fn}{a scalar string with the name of the service's raster function. See \code{\link[=list_raster_fns]{list_raster_fns()}} for available raster functions.}

\item{token}{default \code{arc_token()} authorization token.}
}
\value{
An object of class \code{SpatRaster}.
}
\description{
Given an \code{ImageServer} export an image as a terra \code{SpatRaster} object.
See \code{\link[terra:rast]{terra::rast}}.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\dontrun{
img_url <- "https://landsat2.arcgis.com/arcgis/rest/services/Landsat/MS/ImageServer"

landsat <- arc_open(img_url)

arc_raster(
  landsat,
  xmin = -71,
  xmax = -67,
  ymin = 43,
  ymax = 47.5,
  bbox_crs = 4326,
  width = 100,
  height = 100
)
}

}
