% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalize.hz.R, R/hzTransitionProbabilities.R,
%   R/mostLikelyHzSequence.R
\name{genhzTableToAdjMat}
\alias{genhzTableToAdjMat}
\alias{hzTransitionProbabilities}
\alias{mostLikelyHzSequence}
\title{Convert cross-tabulation to adjacency matrix.}
\usage{
genhzTableToAdjMat(tab)

hzTransitionProbabilities(
  x,
  name = GHL(x, required = TRUE),
  loopTerminalStates = FALSE
)

mostLikelyHzSequence(mc, t0, maxIterations = 10)
}
\arguments{
\item{tab}{table, cross-tabulation of original and generalized horizon labels e.g. \code{table(original, genhz)}}

\item{x}{A \code{SoilProfileCollection} object.}

\item{name}{A horizon level attribute in \code{x} that names horizons.}

\item{loopTerminalStates}{should terminal states loop back to themselves?
This is useful when the transition probability matrix will be used to
initialize a \code{markovchain} object. See examples below.}

\item{mc}{Passed to \code{markovchain} \code{conditionalDistribution()}}

\item{t0}{Passed to \code{markovchain} \code{conditionalDistribution()}}

\item{maxIterations}{Maximum number of iterations. Default: \code{10}}
}
\value{
The function \code{hzTransitionProbabilities} returns a square
matrix of transition probabilities. See examples.

The function \code{genhzTableToAdjMat} returns a square adjacency matrix.
See examples.

The function \code{mostLikelyHzSequence} returns the most likely sequence of
horizons, given a \code{markovchain} object initialized from horizon
transition probabilities and an initial state, \code{t0}. See examples.
}
\description{
Convert a cross-tabulation: {original, genhz} to adjacency matrix.

Functions for creating and working with horizon (sequence) transition
probability matrices.
}
\details{
See the following tutorials for some ideas: \describe{ \item{horizon
designation
TP}{\url{http://ncss-tech.github.io/AQP/aqp/hz-transition-probabilities.html}}
\item{soil color
TP}{\url{http://ncss-tech.github.io/AQP/aqp/series-color-TP-graph.html}} }
}
\note{
These functions are still experimental and subject to change.
}
\examples{

data(sp4)
depths(sp4) <- id ~ top + bottom

# horizon transition probabilities: row -> col transitions
(tp <- hzTransitionProbabilities(sp4, 'name'))


\dontrun{
## plot TP matrix with functions from sharpshootR package
library(sharpshootR)
par(mar=c(0,0,0,0), mfcol=c(1,2))
plot(sp4)
plotSoilRelationGraph(tp, graph.mode = 'directed', edge.arrow.size=0.5)

## demonstrate genhzTableToAdjMat usage
data(loafercreek, package='soilDB')

# convert contingency table -> adj matrix / TP matrix
tab <- table(loafercreek$hzname, loafercreek$genhz)
m <- genhzTableToAdjMat(tab)

# plot
par(mar=c(0,0,0,0), mfcol=c(1,1))
plotSoilRelationGraph(m, graph.mode = 'directed', edge.arrow.size=0.5)


## demonstrate markovchain integration
library(markovchain)
tp.loops <- hzTransitionProbabilities(sp4, 'name', loopTerminalStates = TRUE)

# init new markovchain from TP matrix
mc <- new("markovchain", states=dimnames(tp.loops)[[1]], transitionMatrix = tp.loops)

# simple plot
plot(mc, edge.arrow.size=0.5)

# check absorbing states
absorbingStates(mc)

# steady-state:
steadyStates(mc)
}

}
\seealso{
\code{\link{generalize.hz}}
}
\author{
D.E. Beaudette
}
\keyword{manip}
