% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilProfileCollection-methods.R
\name{subsetProfiles}
\alias{subsetProfiles}
\alias{subsetProfiles,SoilProfileCollection-method}
\title{DEPRECATED use subset}
\usage{
\S4method{subsetProfiles}{SoilProfileCollection}(object, s, h, ...)
}
\arguments{
\item{object}{object}

\item{s}{fully-quoted search criteria for matching
via site-level attributes}

\item{h}{fully-quoted search criteria for matching
via horizon-level attributes}

\item{...}{not used}
}
\value{
A \code{SoilProfileCollection} class object.
}
\description{
This function is used to subset \code{SoilProfileCollection} objects using
either site-level or horizon-level attributes, or both.
}
\details{
The \code{s} argument supplies a fully-quoted search criteria for matching
via site or horizon-level attributes. The \code{h} argument supplies a fully-quoted
search criteria for matching via horizon-level attributes. All horizons
associated with a single horizon-level match (i.e. out of several, only a
single horizon matches the search critera) are returned. See examples for
usage.
}
\examples{

# more interesting sample data
data(sp2)
depths(sp2) <- id ~ top + bottom
site(sp2) <- ~ surface

# subset by integer index, note that this does not re-order the profiles
plot(sp2[1:5, ])

# generate an integer index via pattern-matching
idx <- grep('modesto', sp2$surface, ignore.case=TRUE)
plot(sp2[idx, ])

# generate in index via profileApply:
# subset those profiles where: min(ph) < 5.6
idx <- which(profileApply(sp2, function(i) min(i$field_ph, na.rm=TRUE) < 5.6))
plot(sp2[idx, ])

}
