% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depthOf.R
\name{depthOf}
\alias{depthOf}
\alias{maxDepthOf}
\alias{minDepthOf}
\title{Get top or bottom depths of horizons matching a regular expression pattern}
\usage{
depthOf(
  p,
  pattern,
  top = TRUE,
  hzdesgn = guessHzDesgnName(p),
  no.contact.depth = NULL,
  no.contact.assigned = NA
)
}
\arguments{
\item{p}{A single-profile SoilProfileCollection.}

\item{pattern}{A regular expression to match in the horizon designation column. See:\code{hzdesgn}}

\item{top}{Should the top (TRUE) or bottom (FALSE) depth be returned for matching horizons? Default: \code{TRUE}.}

\item{hzdesgn}{Column name containing horizon designations. Default: \code{guessHzDesgnName(p)}}

\item{no.contact.depth}{Depth to assume that contact did not occur.}

\item{no.contact.assigned}{Depth to assign when a contact did not occur.}
}
\value{
A numeric vector containing specified depth(s) of horizons matching a pattern.
}
\description{
The \code{depthOf} family of functions calculate depth of occurrence of a horizon designation pattern. They are used primarily in the place of complex qualitative or quantitative data that would confirm taxonomic criteria.

Generally, these functions are used to implement assumptions about relationships between diagnostic properties, features and materials and horizon designations commonly used in the field. Particular assumptions may not apply in all localities and/or data sources. Great care should be taken when inspecting results.

If you need all depths of occurrence for a particular pattern, \code{depthOf} is what you are looking for. \code{minDepthOf} and \code{maxDepthOf} are wrappers around \code{depthOf} that return the minimum and maximum depth. They are all set up to handle missing values and missing "contacts" with the target pattern.
}
\examples{
# construct a fake profile
spc <- data.frame(id=1, taxsubgrp = "Lithic Haploxerepts",
                  hzname   = c("A","AB","Bw","BC","R"),
                  hzdept   = c(0,  20, 32, 42,  49),
                  hzdepb   = c(20, 32, 42, 49, 200),
                  clay     = c(19, 22, 22, 21,  NA),
                  texcl    = c("l","l","l", "l","br"),
                  d_value  = c(5,   5,  5,  6,  NA),
                  m_value  = c(2.5, 3,  3,  4,  NA),
                  m_chroma = c(2,   3,  4,  4,  NA))

# promote to SoilProfileCollection
depths(spc) <- id ~ hzdept + hzdepb
hzdesgnname(spc) <- 'hzname'
hztexclname(spc) <- 'texcl'

# multiple horizons contain B
depthOf(spc, "B")

# deepest top depth of horizon containing B
maxDepthOf(spc, "B")

# shallowest top depth
minDepthOf(spc, "B")

# deepest bottom depth
maxDepthOf(spc, "B", top = FALSE)

# deepest bottom depth above 35cm
maxDepthOf(spc, "B", top = FALSE, no.contact.depth = 35)

# assign infinity (Inf) if B horizon does not start within 10cm
minDepthOf(spc, "B", no.contact.depth = 10, no.contact.assigned = Inf)

}
\author{
Andrew G. Brown
}
