% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_power_apsim_met.R
\name{get_power_apsim_met}
\alias{get_power_apsim_met}
\title{Get NASA-POWER data for an APSIM met file}
\usage{
get_power_apsim_met(lonlat, dates, wrt.dir = ".", filename = NULL)
}
\arguments{
\item{lonlat}{Longitude and latitude vector}

\item{dates}{date ranges}

\item{wrt.dir}{write directory}

\item{filename}{file name for writing out to disk}
}
\value{
returns an object of class \sQuote{met} and writes a file to disk when filename is supplied.
}
\description{
Uses \code{\link[nasapower]{get_power}} from the \CRANpkg{nasapower} package to download data to create an APSIM met file.
}
\details{
This function requires the \CRANpkg{nasapower} package version 4.0.0.

It looks like the earliest year you can request data for is 1984.

If the filename is not provided it will not write the file to disk, 
but it will return an object of class \sQuote{met}. This is useful in case manipulation
is required before writing to disk.
}
\examples{
\dontrun{
require(nasapower)
## This will not write a file to disk
pwr <- get_power_apsim_met(lonlat = c(-93,42), dates = c("2012-01-01","2012-12-31"))
## Let's insert a missing value
pwr[100, "radn"] <- NA
summary(pwr)
## Check the met file 
check_apsim_met(pwr)
## Impute using linear interpolation
pwr.imptd <- impute_apsim_met(pwr, verbose = TRUE)
summary(pwr.imptd)
check_apsim_met(pwr.imptd)
}

}
