% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apsim_met.R
\name{tt_apsim_met}
\alias{tt_apsim_met}
\title{Calculates Thermal Time taking a \sQuote{met} object}
\usage{
tt_apsim_met(
  met,
  dates,
  method = c("Classic_TT", "HeatStress_TT", "CropHeatUnit_TT", "APSIM_TT", "CERES_TT",
    "all"),
  x_temp = c(0, 26, 34),
  y_tt = c(0, 26, 0),
  base_temp = 0,
  max_temp = 30,
  dates.format = c("\%d-\%m")
)
}
\arguments{
\item{met}{object of class \sQuote{met}}

\item{dates}{when the calculation starts and when it ends. At the moment
it needs to be a character vector (e.g. c(\sQuote{01-05}, \sQuote{10-10})). It will
use the same dates every year for multiple years.}

\item{method}{one of \sQuote{Classic_TT}, \sQuote{HeatStress_TT}, \sQuote{ASPIM_TT},
\sQuote{CERES_TT} and \sQuote{all}}

\item{x_temp}{cardinal temperatures (base, optimal and maximum)}

\item{y_tt}{thermal time accumulation for cardinal temperatures}

\item{base_temp}{base temperature for Classic TT calculation}

\item{max_temp}{maximum temperature for Classic TT calculation}

\item{dates.format}{default is \sQuote{\%d-\%m} which means day and month}
}
\value{
it returns an object of class \sQuote{met} with additional columns
\sQuote{Date} and the corresponding TT calculation
}
\description{
Calculates Thermal Time using the \sQuote{Classic} formula, 
Heat Stress, Crop Heat Unit and other methods
}
\details{
Calculating Thermal Time using a variety of methods
}
\examples{
\donttest{
require(nasapower)
require(ggplot2)

pwr <- get_power_apsim_met(lonlat = c(-93,42), dates = c("2012-01-01","2015-12-31"))
check_apsim_met(pwr)
pwr <- impute_apsim_met(pwr)

pwr2 <- tt_apsim_met(pwr, dates = c("01-05", "30-10"), method = c("Classic", "Heat"))

ggplot(data = pwr2, aes(x = Date, y = Classic_TT)) + geom_point()

ggplot(data = pwr2, aes(x = Date, y = HeatStress_TT)) + geom_point()

}
}
\references{
Abendroth, L.J., Miguez, F.E., Castellano, M.J. and Hatfield, J.L. (2019),
 Climate Warming Trends in the U.S. Midwest Using Four Thermal Models. 
 Agron. J., 111: 3230-3243. (doi:10.2134/agronj2019.02.0118)
}
