% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit_apsimx_batch.R
\name{edit_apsimx_batch}
\alias{edit_apsimx_batch}
\title{Edit an APSIM-X (JSON) Simulation in Batch mode}
\usage{
edit_apsimx_batch(
  file,
  src.dir = ".",
  wrt.dir = NULL,
  parms = NULL,
  silent = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{file}{file ending in .apsimx to be edited (JSON)}

\item{src.dir}{directory containing the .apsimx file to be edited; defaults to the current working directory}

\item{wrt.dir}{should be used if the destination directory is different from the src.dir}

\item{parms}{parameter to be edited in the for of \sQuote{key = value}}

\item{silent}{controls the output of running APSIM at the command line}

\item{verbose}{whether to print information about successful edit}
}
\value{
(when verbose=TRUE) complete file path to edited .apsimx file is returned as a character string.
As a side effect this function creates a new (JSON) .apsimx file.
}
\description{
This function allows editing of an APSIM-X (JSON) simulation file in batch mode.
}
\details{
from hol430

This allows the user to specify an .apsimx file and a config file when running Models.exe. The .apsimx file will not be run but instead, the changes listed in the config file will be applied to the .apsimx file, which will then be written to disk under the same filename.

The config file should contain lines of the form \sQuote{path = value}

e.g.

[Clock].StartDate = 2019-1-20
.Simulations.Sim1.Name = SimulationVariant35
.Simulations.Sim2.Enabled = false
.Simulations.Sim1.Paddock.Soil.Thickness[1] = 50
Notes:
  
  Command line arguments should look like:
 Models.exe file.apsimx /Edit /path/to/config/file.conf

Relative paths will be resolved to the first match. ie
[Clock].StartDate will match the first clock found in the file.

Dates can be specified as yyyy-mm-dd or mm/dd/yyyy.

Strings should not be quoted

Array indices will be interpted as 1-indexed (mad face). So the first
element in the array should have index 1 in the config file.

The file will be upgraded to the latest file version as part of this
process.
}
\examples{
\dontrun{
## This example will read one of the examples distributed with APSIM-X
## but write to a temporary directory

tmp.dir <- tempdir()

## Edit InitialResidueMass
extd.dir <- system.file("extdata", package = "apsimx")
parms <- list(`.Simulations.Simulation.Field.SurfaceOrganicMatter.InitialResidueMass` = 600)
edit_apsimx_batch("Wheat.apsimx", src.dir = extd.dir, wrt.dir = tmp.dir, parms = parms)
}

}
