% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_avgIntraDraws.R
\name{apollo_avgIntraDraws}
\alias{apollo_avgIntraDraws}
\title{Averages intra-individual draws}
\usage{
apollo_avgIntraDraws(P, apollo_control, functionality)
}
\arguments{
\item{P}{List. Contains the probabilities for each model component, for each inter- and intra-person draw.}

\item{apollo_control}{List. Contains options for the estimation
See \link{apollo_validatecontrol} for details.}

\item{functionality}{Character. Can take different values depending on desired output.
\describe{
  \item{"estimate"}{For model estimation, returns probabilities of chosen alternatives.}
  \item{"prediction"}{For model predictions, returns probabilities of all alternatives.}
  \item{"validate"}{Validates input.}
  \item{"zero_LL"}{Return probabilities with all parameters at zero.}
  \item{"conditionals"}{For conditionals, returns probabilities of chosen alternatives.}
  \item{"output"}{Checks that the model is well defined.}
  \item{"raw"}{For debugging, returns probabilities of all alternatives}
}}
}
\value{
Average probability over intra-individual draws (shape depends on argument \code{functionality}).
}
\description{
Averages the likelihood across intra-individual draws.
}
\details{
This function performs additional checks on the shape of the probabilities given as arguments.
}
