#' Interface to 'episensr' for sensitivity analysis of epidemiological results
#'
#' @description API for using 'episensr' which provides basic sensitivity analysis
#' of the observed relative risks adjusting for unmeasured confounding and
#' misclassification of the exposure/outcome, or both.
#'
#' @references 'episensr' on R CRAN \url{https://cran.r-project.org/package=episensr}
#'
#' @examples
#' \dontrun{
#' run_app()
#' }

#' @keywords internal
"_PACKAGE"

## usethis namespace: start
#' @import golem config attempt glue htmltools shinymaterial rhandsontable rmarkdown ggraph igraph
#' @importFrom shiny NS column shinyApp tagList
#' @importFrom shinyjs reset runjs useShinyjs
## usethis namespace: end
NULL
