% Generated by roxygen2 (4.0.1): do not edit by hand
\name{aoristic.grid}
\alias{aoristic.grid}
\title{aoristic graph by grid count}
\usage{
aoristic.grid(spdf, nxy = 5, output = "output")
}
\arguments{
\item{spdf}{spatial point data frame produced from aoristic.spdf}

\item{nxy}{the number of grids in the x and y directions (a minimum of 2 and a default value of 5)}

\item{output}{a character representing the name of an output folder (the folder will be generated in the current working directory; default name = output)}
}
\value{
kml file
}
\description{
aoristic graph by grid count
}
\examples{
\donttest{
data(aoristic)
data.spdf <- aoristic.spdf(data=arlington,
   DateTimeFrom="DateTimeFrom", DateTimeTo="DateTimeTo",
   lon="lon", lat="lat")
aoristic.grid(spdf=data.spdf, nxy=5)
}
}
\references{
Ratcliffe, J. H. (2002). Aoristic Signatures and the Spatio-Temporal Analysis of High Volume Crime Patterns. Journal of Quantitative Criminology, 18(1), 23-43.
}

