% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ao.R, R/package.R
\docType{package}
\name{ao}
\alias{ao}
\alias{ao-package}
\title{Alternating Optimization}
\usage{
ao(
  f,
  p,
  ...,
  partition = as.list(1:length(p)),
  base_optimizer = optimizer_optim(),
  iterations = 10,
  tolerance = 1e-06,
  print.level = 0,
  plot = FALSE
)
}
\arguments{
\item{f}{A \code{function} to be optimized, returning a single \code{numeric}.
The first argument of \code{f} must be a \code{numeric} of the length of
\code{p} followed by any other arguments specified by the \code{...}
argument.}

\item{p}{A \code{numeric} vector, the starting parameter values for the optimization.}

\item{...}{Additional arguments to be passed to \code{f}.}

\item{partition}{A \code{list} of vectors of indices of \code{p}, specifying the partition of
the alternating optimization.
The default is \code{as.list(1:length(p))}, i.e. each parameter is
optimized separately.
Parameter indices can be members of multiple subsets.}

\item{base_optimizer}{An \code{optimizer} object, which can be specified via
\code{\link[optimizeR]{define_optimizer}}.
The default optimizer is \code{\link[stats]{optim}}.}

\item{iterations}{An \code{integer}, the number of iterations through the parameter indices in
\code{partitions}.
The default is \code{10}.}

\item{tolerance}{A non-negative \code{numeric}. The function terminates prematurely if the
euclidean distance between the current solution and the one from the last
iteration is smaller than \code{tolerance}.
The default is \code{1e-6}.}

\item{print.level}{This argument determines the level of printing which is done during the
optimization process.
Three values (analogue to \code{\link[stats]{nlm}}) can be specified:
\itemize{
\item \code{0} (the default): no printing
\item \code{1}: initial and final details are printed
\item \code{2}: full tracing information is printed
}}

\item{plot}{If \code{TRUE}, the parameter updates are plotted.
The default is \code{FALSE}.}
}
\value{
A \code{list} containing the following components:
\itemize{
\item \code{estimate}: a \code{numeric}, the optimal parameter vector found,
\item \code{optimum}: a \code{numeric}, the value of \code{f} at \code{estimate},
\item \code{sequence}: a \code{data.frame} of the estimates and computation times
in the single iterations,
\item and \code{time}, a \code{difftime} object, the overall computation time.
}
}
\description{
This function performs alternating optimization of the function \code{f}.

Alternating optimization of (high-dimensional) functions is an iterative
procedure for optimizing jointly over all parameters by alternately
optimizing parameter subsets.
}
\examples{
### alternating optimization separately for x_1 and x_2
### parameter restriction: -5 <= x_1, x_2 <= 5
himmelblau <- function(x) (x[1]^2 + x[2] - 11)^2 + (x[1] + x[2]^2 - 7)^2
ao(
  f = himmelblau, p = c(0,0), partition = list(1, 2), iterations = 10,
  base_optimizer = optimizer_optim(lower = -5, upper = 5, method = "L-BFGS-B")
)

}
\seealso{
Useful links:
\itemize{
  \item \url{https://loelschlaeger.de/ao/}
  \item \url{https://github.com/loelschlaeger/ao/}
  \item Report bugs at \url{https://github.com/loelschlaeger/ao/issues}
}

}
\author{
\strong{Maintainer}: Lennart Oelschläger \email{oelschlaeger.lennart@gmail.com} (\href{https://orcid.org/0000-0001-5421-9313}{ORCID})

}
\keyword{internal}
