% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objective-variance.R
\name{variance_objective}
\alias{variance_objective}
\title{Objective value for the variance criterion}
\usage{
variance_objective(x, clusters)
}
\arguments{
\item{x}{A vector, matrix or data.frame of data points. Rows
correspond to elements and columns correspond to features. A
vector represents a single feature.}

\item{clusters}{A vector representing (anti)clusters (e.g., returned
by \code{\link{anticlustering}} or
\code{\link{balanced_clustering}})}
}
\value{
The total within-cluster variance
}
\description{
Compute the k-means variance objective for a given clustering.
}
\details{
The variance objective is given by the sum of the squared
errors between cluster centers and individual data points. It is the
objective function used in k-means clustering, see
\code{\link{kmeans}}.
}
\examples{

data(iris)
## Clustering
clusters <- balanced_clustering(
  iris[, -5],
  K = 3
)
# This is low:
variance_objective(
  iris[, -5],
  clusters
)
## Anticlustering
anticlusters <- anticlustering(
  iris[, -5],
  K = 3,
  objective = "variance"
)
# This is higher:
variance_objective(
  iris[, -5],
  anticlusters
)

# Illustrate variance objective
N <- 18
data <- matrix(rnorm(N * 2), ncol = 2)
cl <- balanced_clustering(data, K = 3)
plot_clusters(data, cl, illustrate_variance = TRUE)
}
\references{
Jain, A. K. (2010). Data clustering: 50 years beyond k-means.
Pattern Recognition Letters, 31, 651–666.

Papenberg, M., & Klau, G. W. (2020). Using anticlustering to partition 
data sets into equivalent parts. Psychological Methods. Advance Online 
Publication. https://doi.org/10.1037/met0000301.

Späth, H. (1986). Anticlustering: Maximizing the variance criterion.
Control and Cybernetics, 15, 213–218.
}
\author{
Martin Papenberg \email{martin.papenberg@hhu.de}
}
