% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{plotMap}
\alias{plotMap}
\title{Display results of a simulation on a map}
\usage{
plotMap(
  x,
  refStudy = NULL,
  mapLayout,
  colAreaVar = "none",
  sizeAreaVars = c(),
  areaChartType = c("bar", "pie", "polar-area", "polar-radius"),
  uniqueScale = FALSE,
  showLabels = FALSE,
  popupAreaVars = c(),
  labelAreaVar = "none",
  colLinkVar = "none",
  sizeLinkVar = "none",
  popupLinkVars = c(),
  type = c("detail", "avg"),
  timeId = NULL,
  mcYear = "average",
  main = "",
  typeSizeAreaVars = FALSE,
  aliasSizeAreaVars = c(),
  compare = NULL,
  compareOpts = list(),
  interactive = getInteractivity(),
  options = plotMapOptions(),
  width = NULL,
  height = NULL,
  dateRange = NULL,
  xyCompare = c("union", "intersect"),
  h5requestFiltering = list(),
  timeSteph5 = "hourly",
  mcYearh5 = NULL,
  tablesh5 = c("areas", "links"),
  sizeMiniPlot = FALSE,
  language = "en",
  hidden = NULL,
  ...
)
}
\arguments{
\item{x}{Object of class \code{antaresDataList} created with 
\code{\link[antaresRead]{readAntares}} and containing areas and links data.
 It can be a list of \code{antaresData} objects. 
 In this case, one chart is created for each object.}

\item{refStudy}{An object of class \code{antaresData} created with function 
\code{\link[antaresRead]{readAntares}} containing data for areas and or
districts. Can also contains an opts who refer to a h5 file.}

\item{mapLayout}{Object created with function \code{\link{mapLayout}}}

\item{colAreaVar}{Name of a variable present in \code{x$areas}. The values of this variable
are represented by the color of the areas on the map. If \code{"none"}, then
the default color is used for all areas.}

\item{sizeAreaVars}{Vector of variables present in \code{x$areas} to associate with the size of 
areas on the map. If this parameter has length equal to 0, all areas have the
same size. If it has length equal to one, then the radius of the areas change
depending on the values of the variable choosen. If it has length greater than
1 then areas are represented by a polar area chart where the size of each section
depends on the values of each variable.}

\item{areaChartType}{If parameter \code{sizeAreaVars} contains multiple variables, this parameter
determines the type of representation. Possible values are \code{"bar"} for
bar charts, \code{"pie"} for pie charts, \code{"polar-area"} and 
\code{"polar-radius"} for polar area charts where the values are represented
respectively by the area or the radius of the slices.}

\item{uniqueScale}{If the map contains polar or bar charts, should the different variables 
represented use the same scale or should each variable have its own scale ?
This parameter should be TRUE only if the variables have the same unit and 
are comparable : for instance production variables.}

\item{showLabels}{Used only when \code{sizeAreaVars} contains multiple variables. If it is 
\code{TRUE}, then values of each variable are displayed.}

\item{popupAreaVars}{Vector of variables to display when user clicks on an area.}

\item{labelAreaVar}{Variable to display inside the areas. This parameter is used only if 
parameter \code{sizeAreaVars} contains zero or one variable.}

\item{colLinkVar}{Name of a variable present in \code{x$links}. The values of this variable
are represented by the color of the links on the map. If \code{"none"}, then
the default color is used for all links}

\item{sizeLinkVar}{Name of a variable present in \code{x$links}. Its values are represented by
the line width of the links on the map.}

\item{popupLinkVars}{Vector of variables to display when user clicks on a link.}

\item{type}{If \code{type="avg"}, the data is averaged by area/and or link and
represented on the map. If it is equal to \code{"detail"}, only one time
step at a time. In interactive mode, an input control permits to choose the
time step shown.}

\item{timeId}{time id present in the data.}

\item{mcYear}{If \code{x}, contains multiple Monte-Carlo scenarios, this parameter 
determine which scenario is displayed. Must be an integer representing the
index of the scenario or the word "average". In this case data are 
averaged.}

\item{main}{Title of the map.}

\item{typeSizeAreaVars}{\code{logical}. Select \code{sizeAreaVars} using alias ? Default to \code{FALSE}}

\item{aliasSizeAreaVars}{If \code{typeSizeAreaVars} is set to TRUE, name of alias. You can find the list 
of alias with the function \code{\link[antaresRead]{showAliases}}}

\item{compare}{An optional character vector containing names of parameters. When it is set,
two charts are outputed with their own input controls. Alternatively, it can
be a named list with names corresponding to parameter names and values being
list with the initial values of the given parameter for each chart. See details
 if you are drawing a map.}

\item{compareOpts}{List of options that indicates the number of charts to create and their 
position. Check out the documentation of 
\code{\link[manipulateWidget]{compareOptions}} to see available options.}

\item{interactive}{LogicalValue. If \code{TRUE}, then a shiny gadget is launched that lets
the user interactively choose the areas or districts to display.}

\item{options}{List of parameters that override some default visual settings. See the
help of \code{\link{plotMapOptions}}.}

\item{width}{Width of the graph expressed in pixels or in percentage of 
the parent element. For instance "500px" and "100\%" are valid values.}

\item{height}{Height of the graph expressed in pixels or in percentage of 
the parent element. For instance "500px" and "100\%" are valid values.}

\item{dateRange}{A vector of two dates. Only data points between these two dates are 
displayed. If NULL, then all data is displayed.}

\item{xyCompare}{Use when you compare studies, can be "union" or "intersect". If union, all
of mcYears in one of studies will be selectable. If intersect, only mcYears in all
studies will be selectable.}

\item{h5requestFiltering}{Contains arguments used by default for h5 request,
typically h5requestFiltering = list(mcYears = 3)}

\item{timeSteph5}{\code{character} timeStep to read in h5 file. Only for Non interactive mode.}

\item{mcYearh5}{\code{numeric} mcYear to read for h5. Only for Non interactive mode.}

\item{tablesh5}{\code{character} tables for h5 ("areas" "links", "clusters" or "disticts"). Only for Non interactive mode.}

\item{sizeMiniPlot}{\code{boolean} variable size for miniplot}

\item{language}{\code{character} language use for label. Defaut to 'en'. Can be 'fr'.}

\item{hidden}{\code{logical} Names of input to hide. Defaut to NULL}

\item{...}{Other arguments for \code{\link{manipulateWidget}}}
}
\value{
An htmlwidget of class "leaflet". It can be modified with package 
\code{leaflet}. By default the function starts a shiny gadget that lets the
user play with most of the parameters of the function. The function returns
a leaflet map when the user clicks on the button \code{"OK"}.
}
\description{
This function generates an interactive map that let the user visually explore
the results of an Antares simulation. By default the function starts a Shiny 
gadget that let the user which variables to represent.
}
\details{
compare argument can take following values :
\itemize{
   \item "mcYear"
   \item "type"
   \item "colAreaVar"
   \item "sizeAreaVars"
   \item "areaChartType"
   \item "showLabels"
   \item "popupAreaVars"
   \item "labelAreaVar"
   \item "colLinkVar"
   \item "sizeLinkVar"
   \item "popupLinkVars"
   \item "typeSizeAreaVars"
   \item "aliasSizeAreaVars"
   }
}
\examples{
\dontrun{
mydata <- readAntares(areas = "all", links = "all", timeStep = "daily",
                      select = "nostat")

# Place areas on a map. Ths has to be done once for a given study. Then the
# object returned by "mapLayout" may be saved and reloaded with
# functions save and load

layout <- readLayout()
ml <- mapLayout(layout = layout)
save("ml", file = "ml.rda")

plotMap(x = mydata, mapLayout = ml)

# Specify the variables to use to control the color or size of elements.
plotMap(mydata, mapLayout =  ml, 
        sizeAreaVars = c("WIND", "SOLAR", "H. ROR"),
        sizeLinkVar = "FLOW LIN.")

# Change default graphical properties
plotMap(x = mydata, mapLayout = ml, options = list(colArea="red", colLink = "orange"))
plotMap(x = list(mydata, mydata), mapLayout =  ml)

# Use custom alias
setAlias("custom_alias", "short description", c("OIL", "GAS", "COAL")) 
plotMap(x = mydata, mapLayout = ml, typeSizeAreaVars = TRUE, 
    aliasSizeAreaVars = "custom_alias")
    
plotMap(x = mydata, mapLayout = ml, interactive = FALSE, 
    language = "fr", aliasSizeAreaVars = "Renouvelable", typeSizeAreaVars = TRUE)

# Use h5 for dynamic request / exploration in a study
# Set path of simulaiton
setSimulationPath(path = path1)

# Convert your study in h5 format
writeAntaresH5(path = myNewPath)

# Redefine sim path with h5 file
opts <- setSimulationPath(path = myNewPath)
plotMap(x = opts, mapLayout = ml)

# Compare elements in a single study
plotMap(x = opts, mapLayout = ml,  .compare = "mcYear")

# Compare 2 studies
plotMap(x = list(opts, opts2), mapLayout = ml)

# Compare 2 studies with argument refStudies 
plotMap(x = opts, refStudy = opts2, mapLayout = ml)
plotMap(x = opts, refStudy = opts2, mapLayout = ml, interactive = FALSE, mcYearh5 = 2) 
plotMap(x = opts, refStudy = opts2, mapLayout = ml, h5requestFiltering = 
list(mcYears = myMcYear))
}

}
