% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readInputClusters.R
\name{readInputThermal}
\alias{readInputThermal}
\title{Read Input thermal time series}
\usage{
readInputThermal(
  clusters = NULL,
  thermalModulation = FALSE,
  thermalData = FALSE,
  opts = simOptions(),
  timeStep = c("hourly", "daily", "weekly", "monthly", "annual"),
  simplify = TRUE,
  parallel = FALSE,
  showProgress = TRUE
)
}
\arguments{
\item{clusters}{vector of clusters names for which thermal time series must be read.}

\item{thermalModulation}{if TRUE, return thermalModulation data}

\item{thermalData}{if TRUE, return thermalData from prepro}

\item{opts}{list of simulation parameters returned by the function
\code{\link{setSimulationPath}}}

\item{timeStep}{Resolution of the data to import: hourly (default), daily,
weekly, monthly or annual.}

\item{simplify}{If TRUE and only one type of output is imported then a
data.table is returned. If FALSE, the result will always be a list of class
"antaresData".}

\item{parallel}{Should the importation be parallelized ? (See details)}

\item{showProgress}{If TRUE the function displays information about the progress of the
importation.}
}
\value{
If thermalModulation or thermalData is TRUE, an object of class "antaresDataList" is returned. It is a list of
data.tables for selected input

Else the result is a data.table with class "antaresDataTable".
}
\description{
\code{readInputThermal} is a function that reads thermal time series from an antares 
project. But contrary to \code{\link{readAntares}}, it only reads time series
stored in the input folder, so it can work in "input" mode.
}
\note{
the clusters parameter can also accept the special value "all". 
It indicates the function to read the desired time series for all clusters.
}
\seealso{
\code{\link{setSimulationPath}}, \code{\link{readAntares}}, 
\code{\link{getAreas}}, \code{\link{getLinks}}
}
