% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare}
\alias{compare}
\title{Compare the surpluses of two simulations}
\usage{
compare(x, y, method = c("diff", "ratio", "rate"))
}
\arguments{
\item{x}{Table of class \code{antaresDataTable}}

\item{y}{Table of class \code{antaresDataTable}. It must contain the same type of data
than 'x': if 'x' contains areas, it must contain areas, ... Moreover it has
to have same time step and contain either synthetic or detailed results like
'x'.}

\item{method}{Method used two compare the two tables. \code{"diff"} compute the difference
between 'y' and 'x'. \code{"ratio"} computes the ratio between 'y' and 'x'.
Finally, \code{"rate"} computes the rate of change between 'y' and 'x' (
it is equal to the ratio between 'y' and 'x' minus one).}
}
\value{
a data.table of class \code{antaresDataTable}. It contains all shared rows and
columns between 'x' and 'y'. The columns contains the statistic choosen:
difference, ratio or rate of change.
}
\description{
\code{compare} has been designed to compare two surpluses created with function
\code{\link{surplus}} but it can be used to compare the values of two tables of
class \code{antaresDataTable} that contain the same type of data.
}
\examples{
\dontrun{
# First simulation
studyPath <- "path/to/study/"

setSimulationPath(studyPath, 1)
mydata1 <- readAntares("all", "all", synthesis = FALSE)
surplus1 <- surplus(mydata1, groupByDistrict = TRUE)

# Second simulation
setSimulationPath(studyPath, 2)
mydata2 <- readAntares("all", "all", synthesis = FALSE)
surplus2 <- surplus(mydata2, groupByDistrict = TRUE)

compare(surplus1, surplus2)
}

}
