% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeHydroValues.R
\name{writeHydroValues}
\alias{writeHydroValues}
\title{Write Hydro Values}
\usage{
writeHydroValues(
  area,
  type,
  data,
  overwrite = TRUE,
  opts = antaresRead::simOptions()
)
}
\arguments{
\item{area}{The area where to add the values.}

\item{type}{Type of hydro file, it can be "waterValues", "reservoir", "maxpower", "inflowPattern" or "creditmodulations".}

\item{data}{The data must have specific dimension depending on the type of file :
\itemize{
\item \code{waterValues}: a 365x101 numeric matrix:
marginal values for the stored energy based on date (365 days)
and on the reservoir level (101 round percentage values ranging from
0\% to 100\%). OR a 3-column matrix with 365x101 rows. In this latter case the 3 columns must
be 'date', 'level' and 'value' (in this order), and the rows must be sorted by:
ascending day, ascending level.
\item \code{reservoir}: a 365x3 numeric matrix. The columns contains respectively the levels min, avg and max.
\item \code{maxpower}: a 365x4 numeric matrix.
\item \code{inflowPattern}: a 365x1 numeric matrix.
\item \code{creditmodulations}: a 2x101 numeric matrix.
}}

\item{overwrite}{Logical. Overwrite the values if a file already exists.}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}.}
}
\description{
\ifelse{html}{\figure{badge_api_ok.svg}{options: alt='Antares API OK'}}{Antares API: \strong{OK}}

Write waterValues, reservoirLevels, maxpower, inflowPattern and creditModulations data for a given area.
}
\section{Warning}{


For an \strong{Antares version >= 860}, control of data consistency between \code{mingen.txt} and \verb{maxpower_<area>.txt} can be executed.

This control depends on the values you find in \code{hydro.ini} file.
}

\examples{
\dontrun{

writeHydroValues("fictive_area", type = "inflowPattern", data = matrix(rep(0, 365*1), nrow = 365))

}
}
