% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeSeriesPrepro.R
\name{writeSeriesPrepro}
\alias{writeSeriesPrepro}
\title{Write prepro data}
\usage{
writeSeriesPrepro(
  area,
  type = c("load", "wind", "solar"),
  coefficients = NULL,
  daily_profile = NULL,
  translation = NULL,
  conversion = NULL,
  overwrite = TRUE,
  opts = antaresRead::simOptions()
)
}
\arguments{
\item{area}{The area where to write prepro data.}

\item{type}{Type of data to write : \code{"load"}, \code{"wind"} or \code{"solar"}.}

\item{coefficients}{A 12*6 matrix of monthly values for the primary
parameters alpha, beta, gamma, delta, theta and mu.}

\item{daily_profile}{A 24*12 matrix of hourly / monthly coefficients K(hm)
that are used to modulate the values of the stationary stochastic process
by which the actual process is approximated.}

\item{translation}{A vector of length 8760 (or 8760*1 matrix) to add to the
time-series generated, prior or after scaling.}

\item{conversion}{A 2*N matrix (with 1<=N<=50) that is used to turn the
initial time-series produced by the generators into final data. See Antares
General Reference Guide.}

\item{overwrite}{Logical. Overwrite the values if a file already exists.}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}.}
}
\description{
\ifelse{html}{\figure{badge_api_no.svg}{options: alt='Antares API NO'}}{Antares API: \strong{NO}}

This function allows to write load, wind and solar prepro data. Using
\code{character(0)} allows to erase data (cf Examples).
}
\examples{
\dontrun{

writeSeriesPrepro("fictive_area", type = "solar", daily_profile = matrix(rep(1, 24*12), nrow = 24))

# Erase daily profile data:
writeSeriesPrepro("fictive_area", type = "solar", daily_profile = character(0))

}
}
