% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/salt.R
\name{salt}
\alias{salt}
\title{Salt a vector.}
\usage{
salt(.x, .seed = NULL, .chars = letters, .n_chars = 5L)
}
\arguments{
\item{.x}{a vector.}

\item{.seed}{an integer to seed the random number generator.}

\item{.chars}{set of characters to salt with.}

\item{.n_chars}{an integer; number of characters to salt with.}
}
\value{
A salted version of the vector.
}
\description{
\code{salt} takes a vector \code{.x} and returns a salted version of it.
The algorithm for salting a vector is:
\enumerate{
  \item Select a random sample of characters of length \code{.n_chars} from \code{.chars}. Call this random sample \code{.y}.
  \item Concatenate \code{.y}, the vector \code{.x}, and \code{.y} again in a vectorized fashion.
}
}
\details{
The user is advised to check out \href{https://en.wikipedia.org/wiki/Salt_\%28cryptography\%29}{Wikipedia} for more information.
}
\examples{
# Use various number of characters
salt(letters, .n_chars = 0L)
salt(letters, .n_chars = 1L)
salt(letters, .n_chars = 5L)
salt(letters)

# Use other sets of characters to salt with
salt(letters, .chars = letters[1:2])
}

