% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{sqlite.tb.indexes}
\alias{sqlite.tb.indexes}
\title{Get sqlite table indexes}
\usage{
sqlite.tb.indexes(sqlite.connect.params = list(dbname = "", table.name = ""))
}
\arguments{
\item{sqlite.connect.params}{Connect to sqlite database params [dbname, table.name]}
}
\description{
Get sqlite table indexes
}
\examples{
test.sqlite <- sprintf('\%s/snp.test.sqlite', tempdir())
test.dat <- system.file('extdata', 'demo/sqlite.dat.txt', package = 'annovarR')
params <- list(dbname = test.sqlite,
table.name = 'snp_test')
x <- sqlite.build(filename = test.dat, params)
x <- sqlite.index(params, index = 'index4', cols = c('V1', 'V2'))
indexes <- sqlite.tb.indexes(params)
test.sqlite <- normalizePath(test.sqlite, '/')
file.remove(test.sqlite)
}
