% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external_tools.R
\name{annovar}
\alias{annovar}
\title{R function to run ANNOVAR.}
\usage{
annovar(perl = Sys.which("perl"), cmd.pool = list(script1.downdb =
  paste(c("{perl}", "{script}{extra.params}", "-downdb", "{buildver}",
  "{webfrom}", "{down.dbname}", "{database.dir}"), collapse = " "),
  script1.gene.based = paste(c("{perl}", "{script}{extra.params}", "{buildver}",
  "{input.file}", "{database.dir}"), collapse = " "), script1.region.based =
  paste(c("{perl}", "{script}", " -regionanno{extra.params}", "{buildver}",
  "{anno.names}", "{input.file}", "{database.dir}"), collapse = " "),
  script1.filter.based = paste(c("{perl}", "{script}",     
  "-filter{extra.params}", "{buildver}", "{anno.names}", "{input.file}",
  "{database.dir}"), collapse = " "), script2 = paste(c("{perl}", "{script}",
  "{input.file}", "{database.dir}", "{buildver}", "{out}",
  "-remove{extra.params}", "-protocol {anno.names}", "-operation",
  "{operation}", "{nastring}", "{otherinfo}", "{vcfinput}"), collapse = " "),
  script3 = paste("{perl}", "{script}{extra.params}", "-format", "{format}",
  "{input.file}", "> {convert.out}", collapse = " ")),
  cmd.used = "script1.downdb", down.dbname = "", input.file = "",
  annovar.dir = "", buildver = "hg19",
  database.dir = "{annovar.dir}/humandb", webfrom = "annovar",
  anno.names = "", out = "", convert.out = "", format = "vcf4",
  operation.type = list(gene.based = c("refGene", "knownGene", "ensGene",
  "ccdsGene"), region.based = c("cytoBand", "genomicSuperDups")),
  cmd.profix.flag = list(buildver = "-buildver", anno.names = "-dbtype",
  webfrom = "-webfrom", out = "-out", nastring = "-nastring"),
  otherinfo = FALSE, nastring = "NA", vcfinput = FALSE,
  extra.params = "", debug = FALSE)
}
\arguments{
\item{perl}{Executable file of perl}

\item{cmd.pool}{Un-parsed commands of ANNOVAR}

\item{cmd.used}{Name in cmd.pool that used to parse final run command}

\item{down.dbname}{Need to download database name, e.g. avsnp147,cosmic70,1000g2015aug}

\item{input.file}{Input file name, e.g. example.avinput, example.vcf}

\item{annovar.dir}{ANNOVAR source code directory}

\item{buildver}{Genome version e.g. hg19, mm10}

\item{database.dir}{Database directory, e.g. /opt/annovar/humandb}

\item{webfrom}{Database resource warehouse, e.g. ucsc, annovar}

\item{anno.names}{ANNOVAR annotation names}

\item{out}{ANNOVAR -out parameter value}

\item{convert.out}{ANNOVAR convert2annovar.pl output file, e.g. out.avinput}

\item{format}{ANNOVAR convert2annovar.pl input format option}

\item{operation.type}{Operation types used in table_annovar.pl}

\item{cmd.profix.flag}{Profix used in ANNOVAR command}

\item{otherinfo}{Used in table_annovar.pl, -otherinfo}

\item{nastring}{ANNOVAR -nastring value, default is NA.}

\item{vcfinput}{Specify that input is in VCF format and output will be in VCF format, table_annovar.pl, -vcfinput}

\item{extra.params}{Extra paramters in ANNOVAR command}

\item{debug}{If set TRUE, only print the command}
}
\description{
R function to run ANNOVAR.
}
\examples{
# original ANNOVAR download.database
down.dbname <- 'refGene'
annovar('perl', cmd.used = 'script1.downdb', down.dbname = 'avsnp147', 
        annovar.dir = '/opt/annovar', debug = TRUE)

# ANNOVAR gene-based annotation
annovar('perl', cmd.used = 'script1.gene.based', input.file = 'example.avinput', 
        annovar.dir = '/opt/annovar', debug = TRUE)

# ANNOVAR gene-based annotation
annovar('perl', cmd.used = 'script1.region.based', anno.names = 'cytoBand', 
        input.file = 'example.avinput', annovar.dir = '/opt/annovar', debug = TRUE)

# ANNOVAR filter-based annotation 
annovar('perl', cmd.used = 'script1.filter.based', anno.names = 'avsnp147', 
        input.file = 'example.avinput', annovar.dir = '/opt/annovar', debug = TRUE)

# ANNOVAR table_annovar.pl
anno.names <- c('refGene','cytoBand','genomicSuperDups','esp6500siv2_all', 
'1000g2015aug_all','1000g2015aug_afr','1000g2015aug_eas','1000g2015aug_eur', 
'snp138','avsnp142','avsnp144','avsnp147','ljb26_all','cosmic70','cosmic81')
annovar('perl', cmd.used = 'script2', 
        anno.names = anno.names, 
        input.file = 'example.avinput', annovar.dir = '/opt/annovar', debug = TRUE)

# ANNOVAR convert2annovar.pl
annovar('perl', cmd.used = 'script3', input.file = 'example.vcf', format = 'vcf4old', 
        convert.out = 'example.avinput', annovar.dir = '/opt/annovar', debug = TRUE)
}
