% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-summary-bin.R, R/stat-summary.r
\name{stat_summary_bin}
\alias{stat_summary_bin}
\alias{stat_summary}
\title{Summarise y values at unique/binned x x.}
\usage{
stat_summary_bin(
  mapping = NULL,
  data = NULL,
  geom = "pointrange",
  position = "identity",
  ...,
  fun.data = NULL,
  fun.y = NULL,
  fun.ymax = NULL,
  fun.ymin = NULL,
  fun.args = list(),
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_summary(
  mapping = NULL,
  data = NULL,
  geom = "pointrange",
  position = "identity",
  ...,
  fun.data = NULL,
  fun.y = NULL,
  fun.ymax = NULL,
  fun.ymin = NULL,
  fun.args = list(),
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{fun.data}{A function that is given the complete data and should
return a data frame with variables \code{ymin}, \code{y}, and \code{ymax}.}

\item{fun.ymin, fun.y, fun.ymax}{Alternatively, supply three individual
functions that are each passed a vector of x's and should return a
single number.}

\item{fun.args}{Optional additional arguments passed on to the functions.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}
}
\description{
\code{stat_summary} operates on unique \code{x}; \code{stat_summary_bin}
operators on binned \code{x}. They are more flexible versions of
\code{\link{stat_bin}}: instead of just counting, they can compute any
aggregate.
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{animint2:::rd_aesthetics("stat", "summary")}
}

\section{Summary functions}{

You can either supply summary functions individually (\code{fun.y},
\code{fun.ymax}, \code{fun.ymin}), or as a single function (\code{fun.data}):

\describe{
  \item{fun.data}{Complete summary function. Should take numeric vector as
     input and return data frame as output}
  \item{fun.ymin}{ymin summary function (should take numeric vector and
    return single number)}
  \item{fun.y}{y summary function (should take numeric vector and return
    single number)}
  \item{fun.ymax}{ymax summary function (should take numeric vector and
    return single number)}
}

A simple vector function is easiest to work with as you can return a single
number, but is somewhat less flexible. If your summary function computes
multiple values at once (e.g. ymin and ymax), use \code{fun.data}.

If no aggregation functions are suppled, will default to
\code{\link{mean_se}}.
}

\seealso{
\code{\link{geom_errorbar}}, \code{\link{geom_pointrange}},
 \code{\link{geom_linerange}}, \code{\link{geom_crossbar}} for geoms to
 display summarised data
}
