% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsample_permuted_networks.R
\name{subsamples_permuted_networks}
\alias{subsamples_permuted_networks}
\title{To generate subsamples of the permuted networks and obtain network metrics of those subsamples}
\usage{
subsamples_permuted_networks(
  networks_list,
  subsampling_proportion = c(0.1, 0.3, 0.5, 0.7, 0.9),
  network_metrics = c("density", "mean_strength", "diameter", "transitivity")
)
}
\arguments{
\item{networks_list}{A list of igraph objects obtained by permuting the observed network}

\item{subsampling_proportion}{A vector depicting the levels (in proportion) at which subsamples to be taken}

\item{network_metrics}{A vector depicting names of global network metrics. Default = network_metrics = c("density", "mean_strength", "diameter", "transitivity")}
}
\value{
A list of network metrics of class "Subsampled_Permuted_Network_Metrics". Each element of list is a matrix whose columns 
        correspond to subsampling_proportion and rows correspond to the number of networks in networks_list. 
        The entries of the matrix provide values of the corresponding metric.
}
\description{
To generate subsamples of the permuted networks and obtain network metrics of those subsamples
}
\examples{
\donttest{
data(elk_2010_permutations)
subsamples_permuted_networks(elk_2010_permutations)
}
}
