% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findPeaks.R
\name{findPeaks}
\alias{findPeaks}
\title{findPeaks}
\usage{
findPeaks(
  data,
  resolution = 4,
  minAbs = 0.1,
  cutOff = NULL,
  scale = TRUE,
  ndd = TRUE
)
}
\arguments{
\item{data}{A data frame object, which contains in the first column the wave
numbers and in the following columns the samples absorbances.}

\item{resolution}{The equipment measurement resolution; by default 4 cm-1.}

\item{minAbs}{The cut off value to check spectra quality; by default 0.1.}

\item{cutOff}{The second derivative/absorbance sum spectrum cut off to reduce
the raw peaks table; by default NULL.}

\item{scale}{By default (TRUE) the data is scaled by Z-scores. Use FALSE in
case you do not want to scale it.}

\item{ndd}{By default (TRUE) the peaks are searched based on the second
derivative sum spectrum. Use FALSE in case you want to search them based on
the absorbance sum spectrum.}
}
\value{
A list with a collection of data frames which contains:
\enumerate{
  \item \emph{dataZ}: the standardised data by Z-scores.
  \item \emph{secondDerivative}: the second derivative values of the data.
  \item \emph{sumSpectrum_peaksTable}: the peaks wave numbers and their
second derivative/absorbance sum spectrum values.
  \item \emph{peaksTable}: the selected peaks wave numbers and their
  absorbance for each spectrum.
}
}
\description{
This function finds peaks and allows to the most relevant based
  on the second derivative/absorbance sum spectrum.
}
\examples{
# Find Peaks based on the absorbance sum spectrum
fp.abs <- findPeaks(andurinhaData, ndd = FALSE)

# See the peaks table of the absorbance sum spectrum
fp.abs$sumSpectrum_peaksTable

# Find Peaks based on the second derivative sum spectrum
fp.ndd <- findPeaks(andurinhaData)

# See the peaks table of the second derivative sum spectrum
fp.ndd$sumSpectrum_peaksTable

# Select a cutOff to reduce the number of peaks in the table
# (i.e. select the most relevant)
# fp.ndd$sumSpectrum_peaksTable \%>\%
#   arrange(desc(sumSpectrum))
# Run findPeaks() with the new cutOff
fp.ndd2 <- findPeaks(andurinhaData, cutOff = 0.25)

}
\seealso{
\code{\link{importSpectra}}, \code{\link{gOverview}} and
  \code{\link{plotPeaks}}
}
