% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-functions.R,
%   R/core-functions-meta-pipelines.R
\docType{methods}
\name{savePipeline}
\alias{savePipeline}
\alias{savePipeline,BaseAnalysisPipeline-method}
\alias{savePipeline,MetaAnalysisPipeline-method}
\title{Saves the \code{AnalysisPipeline} or \code{StreamingAnalysisPipeline} object to the file system without outputs}
\usage{
savePipeline(object, path)

\S4method{savePipeline}{BaseAnalysisPipeline}(object, path)

\S4method{savePipeline}{MetaAnalysisPipeline}(object, path)
}
\arguments{
\item{object}{object that contains input, pipeline, registry and output}

\item{path}{the path at which the .Rda file containing the pipeline should be stored, along with the name of the file including
a .Rda extension}
}
\value{
Does not return a value
}
\description{
Saves the \code{AnalysisPipeline} or \code{StreamingAnalysisPipeline} object to the file system without outputs
}
\details{
The \code{AnalysisPipeline} or \code{StreamingAnalysisPipeline} object is saved to the file system in the paths specified

This method is implemented on the base class as it is a shared functionality types of Analysis Pipelines
which extend this class
}
\examples{
\dontrun{
  library(analysisPipelines)
  pipelineObj <- AnalysisPipeline(input = iris)
  pipelineObj \%>>\% savePipeline(path = "./test.RDS")
}
}
\seealso{
Other Package core functions: \code{\link{BaseAnalysisPipeline-class}},
  \code{\link{MetaAnalysisPipeline-class}},
  \code{\link{assessEngineSetUp}},
  \code{\link{checkSchemaMatch}},
  \code{\link{createPipelineInstance}},
  \code{\link{exportAsMetaPipeline}},
  \code{\link{generateOutput}},
  \code{\link{genericPipelineException}},
  \code{\link{getInput}}, \code{\link{getLoggerDetails}},
  \code{\link{getOutputById}},
  \code{\link{getPipelinePrototype}},
  \code{\link{getPipeline}}, \code{\link{getRegistry}},
  \code{\link{initDfBasedOnType}},
  \code{\link{initialize,BaseAnalysisPipeline-method}},
  \code{\link{loadMetaPipeline}},
  \code{\link{loadPipeline}},
  \code{\link{loadPredefinedFunctionRegistry}},
  \code{\link{loadRegistry}}, \code{\link{prepExecution}},
  \code{\link{registerFunction}},
  \code{\link{saveRegistry}}, \code{\link{setInput}},
  \code{\link{setLoggerDetails}},
  \code{\link{updateObject}},
  \code{\link{visualizePipeline}}
}
\concept{Package core functions}
