% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r-helper-utilites-python.R
\name{getFeaturesForPyClassification}
\alias{getFeaturesForPyClassification}
\title{Extracts selected columns from a data frame as a Python array}
\usage{
getFeaturesForPyClassification(dataset, featureNames)
}
\arguments{
\item{dataset}{an R data frame}

\item{featureNames}{Column names to be extracted from the R data frames. A character vector.}
}
\description{
Extracts selected columns from a data frame as a Python array
}
\details{
Helper function, which when provided an R data frame and a set of column/ feature names,
extracts them from the R data frame as a matrix and converts them to the equivalent Python array.

Typically this function can be used when providing a feature matrix to a Python machine learning function
}
\examples{
\dontrun{
 getFeaturesForPyClassification(dataset = iris,
 featureNames = c("Sepal.Length", "Sepal.Width"))
}
}
\seealso{
Other R helper utilities for Python: \code{\link{getTargetForPyClassification}},
  \code{\link{setPythonEnvir}}
}
\concept{R helper utilities for Python}
