% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r-batch-eda-utilities.R
\name{bivarPlots}
\alias{bivarPlots}
\title{Bi-Variate Plot}
\usage{
bivarPlots(dataset, select_var_name_1, select_var_name_2,
  priColor = "blue", secColor = "black")
}
\arguments{
\item{dataset}{the dataframe that needs to be loaded}

\item{select_var_name_1}{the name of first column on which the plot needs to be generated}

\item{select_var_name_2}{the name of second column on which the plot needs to be generated}

\item{priColor}{the primary color for the plots}

\item{secColor}{A secondary color for the plots}
}
\value{
Bivariate plot
}
\description{
Bi-Variate Plot
}
\details{
A bivariate distribution graph on the selected columns from the dataframe.Selected two columns are on two axis' and a plot is generated
}
\examples{
bivarPlots(dataset = iris, select_var_name_1 = "Sepal.Length",
 select_var_name_2 = "Sepal.Width")
}
\seealso{
Other Package EDA Utilites functions: \code{\link{CheckColumnType}},
  \code{\link{correlationMatPlot}},
  \code{\link{getDatatype}}, \code{\link{ignoreCols}},
  \code{\link{multiVarOutlierPlot}},
  \code{\link{outlierPlot}},
  \code{\link{univarCatDistPlots}}
}
\concept{Package EDA Utilites functions}
