% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uhc_plots.R
\name{ua_distr}
\alias{ua_distr}
\title{Summarize distribution of used and available}
\usage{
ua_distr(name, type, data, lims, resp, n_dens, avail = TRUE)
}
\arguments{
\item{name}{\verb{[character]} Name of the column to summarize.}

\item{type}{\verb{[character]} Either \code{"numeric"} or \code{"factor"} as returned by
\code{\link{prep_test_dat}()}.}

\item{data}{\verb{[data.frame]} The \code{data.frame} containing the columns and the
response variable.}

\item{lims}{\verb{[numeric(2)]} A \code{numeric} vector of length 2 containing the
range for the density calculation for all variables where \code{type == "numeric"}
as returned by \code{\link{prep_test_dat}()}. Will be passed to
\code{stats::density.default()} arguments \code{from} and \code{to}.}

\item{resp}{\verb{[character]} Name of the response variable.}

\item{n_dens}{\verb{[numeric]} A \code{numeric} vector of length 1 giving the number of
equally spaced points at which density (used, available, and sampled) is
estimated. Passed to \code{stats::density.default()}, which indicates that \code{n}
should usually be specified as a power of 2.}

\item{avail}{\verb{[logical]} Should distribution be calculated for the available
locations? Defaults to \code{TRUE}, but should be false when summarizing the
bootstrapped "used" samples.}
}
\description{
Internal function to summarize distribution of numeric or factor variables
}
