% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uhc_plots.R
\name{as.data.frame.uhc_data}
\alias{as.data.frame.uhc_data}
\title{Coerce a \code{uhc_data} object to \code{data.frame}}
\usage{
\method{as.data.frame}{uhc_data}(x, row.names = NULL, optional = FALSE, ...)
}
\arguments{
\item{x}{\verb{[uhc_data]} An object of class \code{uhc_data}, as returned
by the function \code{\link{prep_uhc}()}.}

\item{row.names}{Included for consistency with generic
\code{\link{as.data.frame}()}. Currently ignored.}

\item{optional}{Included for consistency with generic
\code{\link{as.data.frame}()}. Currently ignored.}

\item{...}{Included for consistency with generic
\code{\link{as.data.frame}()}. Currently ignored.}
}
\value{
Returns a \code{data.frame} with columns:
\itemize{
\item \code{var}: The name of the variable
\item \code{x}: The x-coordinate of the density plot (the value of \code{var}).
\item \code{y}: The y-coordinate of the density plot (the probability density for
a numeric \code{var} and the proportion for a factor \code{var}).
\item \code{dist}: The distribution represented. Either \code{"U"} for used, \code{"A"} for
available, or \code{"S"} for sampled.
\item \code{iter}: The iteration number if \code{dist == "S"}.
\item \code{label}: The label if \code{var} is a factor.
}
}
\description{
Coerces \code{uhc_data} from \code{list} to \code{data.frame}
}
\details{
This coercion aims to keep all of the information contained in
the \code{uhc_data} \code{list} in the resulting \code{data.frame} representation. Factors
are converted to numeric, but the levels are retained in the column
\code{"label"}.
}
\seealso{
\code{\link{prep_uhc}()}, \code{\link{conf_envelope}()}
}
\author{
Brian J. Smith
}
