% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-uhc.R
\docType{data}
\name{uhc_hsf_locs}
\alias{uhc_hsf_locs}
\title{Simulated HSF location data for demonstrating UHC plots}
\format{
A \code{data.frame} with 2000 rows and 2 variables:
\describe{
\item{x}{x-coordinate in UTM Zone 12 (EPSG: 32612)}
\item{y}{Y-coordinate in UTM Zone 12 (EPSG: 32612)}
}

These data were simulated assuming an ordinary habitat selection function
(HSF), i.e., all points are independent rather than arising from an
underlying movement model.

True parameter values are:
\itemize{
\item \code{forage} = log(5)/500 (resource)
\item \code{temp^2} = -1 * log(2)/36 (condition; quadratic term)
\item \code{temp} = (log(2)/36) * 26 (condition; linear term)
\item \code{pred} = log(0.25)/5 (risk)
\item \code{cover == "forest"} = log(2) (grassland is intercept)
\item \code{cover == "wetland"} = log(1/2) (grassland is intercept)
}

Note: \code{temp} is modeled as a quadratic term, with the strongest selection
occurring at 13 °C and all other temperatures less selected.

Note: \code{dist_to_water}, \code{dist_to_cent}, and \code{rand} have no real effect
on our animal's selection and are included for demonstration purposes.
}
\usage{
uhc_hsf_locs
}
\description{
Simulated HSF location data for demonstrating UHC plots
}
\keyword{datasets}
